/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * HashMapAdapter.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.util;

import java.util.HashMap;
import java.util.List;
import java.util.Set;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class HashMapAdapter extends XmlAdapter<HashMapType, HashMap<String, String>> {

    @Override
    public HashMapType marshal(HashMap<String, String> hashMap) throws Exception {
        HashMapType hashMapType = null;
        if (hashMap != null && hashMap.size() > 0) {
            hashMapType = new HashMapType();
            Set<String> keys = hashMap.keySet();
            for (String key : keys) {
                HashMapEntryType entryType = new HashMapEntryType();
                entryType.setKey(key);
                entryType.setValue(hashMap.get(key));
                hashMapType.addEntry(entryType);
            }
        }
        return hashMapType;
    }

    @Override
    public HashMap<String, String> unmarshal(HashMapType hashMapType) throws Exception {
        HashMap<String, String> hashMap = null;
        if (hashMapType != null) {
            hashMap = new HashMap<String, String>();
            List<HashMapEntryType> entries = hashMapType.getEntry();
            if (entries != null) {
                for (HashMapEntryType entry : entries) {
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return hashMap;
    }
}
