/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.util.List;
import javax.jws.WebService;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PersonSearchProperties;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.organization.PersonManagerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="org.ow2.dragon.service.organization.PersonManagerService")
public class PersonManagerServiceImpl
implements PersonManagerService {
    private PersonManager personManager;

    public void setPersonManager(PersonManager personManager) {
        this.personManager = personManager;
    }

    @Override
    public String createPerson(PersonTO personTO) throws DragonFault {
        try {
            return this.personManager.createPerson(personTO);
        }
        catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public List<PersonTO> getAllPersons(RequestOptionsTO requestOptionsTO) {
        return this.personManager.getAllPersons(requestOptionsTO);
    }

    @Override
    public PersonTO getPerson(String personId) throws DragonFault {
        try {
            return this.personManager.getPerson(personId);
        }
        catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public void removePerson(String personId) {
        this.personManager.removePerson(personId);
    }

    @Override
    public List<PersonTO> searchPersons(String searchCriteria, List<PersonSearchProperties> searchedProperties, RequestOptionsTO iOptions) throws DragonFault {
        try {
            return this.personManager.searchPersons(searchCriteria, searchedProperties, iOptions);
        }
        catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public String updatePerson(PersonTO personTO) throws DragonFault {
        try {
            return this.personManager.updatePerson(personTO);
        }
        catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }
}

