/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdl;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebService;
import javax.mail.util.ByteArrayDataSource;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.wsdl.AttachedDescription;
import org.ow2.dragon.service.wsdl.WSDLManagerService;
import org.ow2.dragon.util.XMLUtil;
import org.w3c.dom.Document;

@WebService(endpointInterface="org.ow2.dragon.service.wsdl.WSDLManagerService")
public class WSDLManagerServiceImpl
implements WSDLManagerService {
    private WSDLManager manager;

    public WSDLManager getManager() {
        return this.manager;
    }

    public String[] importServiceDefFile(String wsdlURI) throws DragonFault {
        String[] result = null;
        URI uri = URI.create(wsdlURI);
        try {
            result = this.manager.importServiceDefFile(uri);
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    public void setManager(WSDLManager manager) {
        this.manager = manager;
    }

    public String[] importServiceDefFile(AttachedDescription attachedDescription) throws DragonFault {
        String[] result = null;
        try {
            DataHandler desc = attachedDescription.getDescription();
            Document documentDesc = XMLUtil.loadDocument((InputStream)desc.getInputStream());
            documentDesc.setDocumentURI(".");
            result = this.manager.importServiceDefFile(documentDesc);
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    public String loadServiceDescAsString(String serviceId) throws DragonFault {
        String result = null;
        try {
            List specs = this.manager.getServSpecsForTechServ(serviceId);
            result = this.manager.getWsdlDescAsString(((ServiceSpecificationTO)specs.get(0)).getId());
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    public AttachedDescription loadServiceDesc(String serviceId) throws DragonFault {
        AttachedDescription description = new AttachedDescription();
        try {
            List specs = this.manager.getServSpecsForTechServ(serviceId);
            InputStream inputStream = this.manager.getWsdlDesc(((ServiceSpecificationTO)specs.get(0)).getId());
            description.setDescription(new DataHandler((DataSource)new ByteArrayDataSource(inputStream, "application/octet-stream")));
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return description;
    }
}

