/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TModelManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.common;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.api.to.common.IdentifierTO;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebService
public interface TModelManagerService {

    @WebMethod(operationName = "loadCategoryValues")
    List<CategoryValueTO> loadCategoryValues(@WebParam(name = "categoryId") String categoryId);

    @WebMethod(operationName = "loadEndpointCategories")
    List<CategoryTO> loadEndpointCategories();

    @WebMethod(operationName = "loadOrganizationCategories")
    List<CategoryTO> loadOrganizationCategories();

    @WebMethod(operationName = "loadOrganizationIdentifierSystems")
    List<IdentifierTO> loadOrganizationIdentifierSystems();

    @WebMethod(operationName = "loadServiceCategories")
    List<CategoryTO> loadServiceCategories();

}
