/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.deployment;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.ServiceSearchProperties;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebService
public interface ServiceManagerService {

    @WebMethod(operationName = "removeService")
    void removeService(@WebParam(name = "serviceId") String serviceId) throws DragonFault;

    @WebMethod(operationName = "getAllServices")
    List<TechnicalServiceTO> getAllTechServices(
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptions) throws DragonFault;

    @WebMethod(operationName = "getService")
    TechnicalServiceTO getService(@WebParam(name = "serviceId") String serviceId)
            throws DragonFault;

    @WebMethod(operationName = "addRelatedDoc")
    String addRelatedDoc(@WebParam(name = "serviceId") String serviceId,
            @WebParam(name = "mimetype") String mimetype,
            @WebParam(name = "attachedDocument") AttachedDocument attachedDocument,
            @WebParam(name = "fileName") String fileName) throws DragonFault;

    @WebMethod(operationName = "addCategory")
    void addCategory(@WebParam(name = "serviceId") String techServiceId,
            @WebParam(name = "categoryId") String categoryId,
            @WebParam(name = "categoryValue") String categoryValue,
            @WebParam(name = "categoryDesc") String categoryDesc) throws DragonFault;

    @WebMethod(operationName = "addSpecifiedCategory")
    void addCategory(@WebParam(name = "serviceId") String techServiceId,
            @WebParam(name = "categoryId") String categoryId,
            @WebParam(name = "categoryValueId") String categoryValueId) throws DragonFault;

    @WebMethod(operationName = "getCategoriesForServ")
    List<KeyedRefTO> getCategoriesForTechServ(@WebParam(name = "serviceId") String techServiceId)
            throws DragonFault;

    @WebMethod(operationName = "getRelatedDocContent")
    AttachedDocument getRelatedDocContent(@WebParam(name = "relatedDocId") String relatedDocId)
            throws DragonFault;

    @WebMethod(operationName = "getRelatedDocsForServ")
    List<SimpleFileTO> getRelatedDocsForTechServ(@WebParam(name = "serviceId") String techServiceId)
            throws DragonFault;

    @WebMethod(operationName = "removeCategories")
    void removeCategories(@WebParam(name = "serviceId") String techServiceId,
            @WebParam(name = "categoryIds") List<String> categoryIds) throws DragonFault;

    @WebMethod(operationName = "searchService")
    List<TechnicalServiceTO> searchTechService(
            @WebParam(name = "searchCriteria") String searchCriteria,
            @WebParam(name = "searchedProperties") List<ServiceSearchProperties> searchedProperties,
            @WebParam(name = "requestOptions") RequestOptionsTO iOptions) throws DragonFault;

    @WebMethod(operationName = "updateService")
    String updateTechService(@WebParam(name = "service") TechnicalServiceTO techServiceTO)
            throws DragonFault;

}
