/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationManagerService.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.organization;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.organization.OrganizationSearchProperties;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@WebService
public interface OrganizationManagerService {

    @WebMethod(operationName = "getAllOrganizations")
    public List<OrganizationUnitTO> getAllOrganizations(
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getOrganization")
    public OrganizationUnitTO getOrganization(
            @WebParam(name = "organizationId") String organizationId) throws DragonFault;

    @WebMethod(operationName = "removeOrganization")
    public void removeOrganization(@WebParam(name = "organizationId") String organizationId);

    @WebMethod(operationName = "searchOrganization")
    public List<OrganizationUnitTO> searchOrganization(
            @WebParam(name = "searchCriteria") String searchCriteria,
            @WebParam(name = "searchedProperties") List<OrganizationSearchProperties> searchedProperties,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "createOrganization")
    public String createOrganization(
            @WebParam(name = "organizationUnit") OrganizationUnitTO organizationUnitTO)
            throws DragonFault;

    @WebMethod(operationName = "addPost")
    public void addPost(@WebParam(name = "organizationId") String organizationId,
            @WebParam(name = "postId") String postId) throws DragonFault;

    @WebMethod(operationName = "getCategoriesForOrg")
    public List<KeyedRefTO> getCategoriesForOrg(@WebParam(name = "organizationId") String orgId)
            throws DragonFault;

    @WebMethod(operationName = "getIdentifiersForOrg")
    public List<KeyedRefTO> getIdentifiersForOrg(@WebParam(name = "organizationId") String orgId)
            throws DragonFault;

    @WebMethod(operationName = "removePost")
    public void removePost(@WebParam(name = "organizationId") String organizationId,
            @WebParam(name = "postId") String postId) throws DragonFault;

    @WebMethod(operationName = "updateOrganization")
    public String updateOrganization(
            @WebParam(name = "organizationUnit") OrganizationUnitTO organizationUnitTO)
            throws DragonFault;

}
