/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PersonManagerService.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.organization;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PersonSearchProperties;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre
 * 
 */
@WebService
public interface PersonManagerService {

    @WebMethod(operationName = "createPerson")
    public String createPerson(@WebParam(name = "person") PersonTO personTO) throws DragonFault;

    @WebMethod(operationName = "getAllPersons")
    public List<PersonTO> getAllPersons(
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO);

    @WebMethod(operationName = "getPerson")
    public PersonTO getPerson(@WebParam(name = "personId") String personId) throws DragonFault;

    @WebMethod(operationName = "removePerson")
    public void removePerson(@WebParam(name = "personId") String personId);

    @WebMethod(operationName = "searchPersons")
    public List<PersonTO> searchPersons(@WebParam(name = "searchCriteria") String searchCriteria,
            @WebParam(name = "searchedProperties") List<PersonSearchProperties> searchedProperties,
            @WebParam(name = "requestOptions") RequestOptionsTO requestOptionsTO)
            throws DragonFault;

    @WebMethod(operationName = "updatePerson")
    public String updatePerson(@WebParam(name = "person") PersonTO personTO) throws DragonFault;

}
