/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationManagerServiceImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.organization;

import java.util.List;

import javax.jws.WebService;

import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager.LINK_TYPE;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.OrgToEndpointTO;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.api.to.organization.PersonToTechServiceTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@WebService(endpointInterface = "org.ow2.dragon.service.organization.RoleOfPartyManagerService")
public class RoleOfPartyManagerServiceImpl implements RoleOfPartyManagerService {

    private RoleOfPartyManager roleOfPartyManager;

    public void setRoleOfPartyManager(RoleOfPartyManager roleOfPartyManager) {
        this.roleOfPartyManager = roleOfPartyManager;
    }

    public String createEndpointRole(String partyId, String endpointId, String type)
            throws DragonFault {
        try {
            return roleOfPartyManager.createEndpointRole(partyId, endpointId, type);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public String createTechServiceRole(String partyId, String technicalServiceId, String type)
            throws DragonFault {
        try {
            return roleOfPartyManager.createTechServiceRole(partyId, technicalServiceId, type);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<OrgToEndpointTO> getOrgRolesByEndpoint(String endpointId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getOrgRolesByEndpoint(endpointId, requestOptionsTO);
    }

    public List<OrgToTechServiceTO> getOrgRolesByTechService(String techServiceId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getOrgRolesByTechService(techServiceId, requestOptionsTO);
    }

    public List<PersonToEndpointTO> getPersonRolesByEndpoint(String endpointId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getPersonRolesByEndpoint(endpointId, requestOptionsTO);
    }

    public List<PersonToTechServiceTO> getPersonRolesByTechService(String techServiceId,
            RequestOptionsTO requestOptionsTO) {
        return roleOfPartyManager.getPersonRolesByTechService(techServiceId, requestOptionsTO);
    }

    public String[] getRolesTypes(LINK_TYPE linkType, RequestOptionsTO iOptions) {
        return roleOfPartyManager.getRolesTypes(linkType, iOptions);
    }

    public void removeRole(String roleId) {
        roleOfPartyManager.removeRole(roleId);
    }

}
