/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * WSDLManagerService.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.wsdl;

import java.util.HashMap;
import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.util.HashMapAdapter;

@WebService
public interface WSDLManagerService {

    @WebMethod(operationName = "importServiceFromURI")
    String[] importServiceDefFile(@WebParam(name = "wsdlURI") String wsdlURI) throws DragonFault;

    @WebMethod(operationName = "importServiceFromURIAndRelativeImportURIs")
    String[] importServiceDefFileWithRelativeImports(
            @WebParam(name = "wsdlURI") String wsdlURI,
            @WebParam(name = "imports") @XmlJavaTypeAdapter(HashMapAdapter.class) HashMap<String, String> imports)
            throws DragonFault;

    @WebMethod(operationName = "importServiceFromAttachment")
    String[] importServiceDefFile(
            @WebParam(name = "attachedDescription") AttachedDescription attachedDescription)
            throws DragonFault;

    @WebMethod(operationName = "loadServiceDescsAsString")
    List<String> loadServiceDescsAsString(@WebParam(name = "serviceId") String serviceId)
            throws DragonFault;

    @WebMethod(operationName = "loadServiceDescsAsAttachment")
    List<AttachedDescription> loadServiceDescs(@WebParam(name = "serviceId") String serviceId)
            throws DragonFault;

    @WebMethod(operationName = "loadEndpointDescsAsString")
    List<String> loadEndpointDescsAsString(@WebParam(name = "endpointId") String endpointId)
            throws DragonFault;

    @WebMethod(operationName = "loadEndpointDescsAsAttachment")
    List<AttachedDescription> loadEndpointDescs(@WebParam(name = "endpointId") String endpointId)
            throws DragonFault;

}
