/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * DragonFault.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service;

import javax.xml.ws.WebFault;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebFault(name = "DragonFault", targetNamespace = "http://dragon.ow2.org", faultBean = "org.ow2.dragon.service.DragonFault")
public class DragonFault extends Exception {

    /**
     * 
     */
    private static final long serialVersionUID = -6901029685186349925L;

    private String message;

    private DragonFaultDetail faultDetail;

    public DragonFault(String message, DragonFaultDetail faultDetail) {
        super();
        this.message = message;
        this.faultDetail = faultDetail;
    }

    public DragonFault(String message, Throwable t) {
        super();
        this.message = message;
        DragonFaultDetail faultDetail = new DragonFaultDetail();
        faultDetail.setFaultStack(getStackTrace(t));
        this.faultDetail = faultDetail;
    }

    public DragonFault(String message) {
        super();
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DragonFaultDetail getFaultDetail() {
        return faultDetail;
    }

    public void setFaultDetail(DragonFaultDetail faultDetail) {
        this.faultDetail = faultDetail;
    }

    public String getStackTrace(Throwable t) {
        java.io.StringWriter out = new java.io.StringWriter();
        t.printStackTrace(new java.io.PrintWriter(out));
        String stackTrace = out.toString();

        return stackTrace;
    }

}
