/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PersonManagerServiceImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.organization;

import java.util.List;

import javax.jws.WebService;

import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PersonSearchProperties;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre
 * 
 */
@WebService(endpointInterface = "org.ow2.dragon.service.organization.PersonManagerService")
public class PersonManagerServiceImpl implements PersonManagerService {

    private PersonManager personManager;

    public void setPersonManager(PersonManager personManager) {
        this.personManager = personManager;
    }

    public String createPerson(PersonTO personTO) throws DragonFault {
        try {
            return personManager.createPerson(personTO);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<PersonTO> getAllPersons(RequestOptionsTO requestOptionsTO) {
        return personManager.getAllPersons(requestOptionsTO);
    }

    public PersonTO getPerson(String personId) throws DragonFault {
        try {
            return personManager.getPerson(personId);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void removePerson(String personId) {
        personManager.removePerson(personId);
    }

    public List<PersonTO> searchPersons(String searchCriteria,
            List<PersonSearchProperties> searchedProperties, RequestOptionsTO iOptions)
            throws DragonFault {
        try {
            return personManager.searchPersons(searchCriteria, searchedProperties, iOptions);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public String updatePerson(PersonTO personTO) throws DragonFault {
        try {
            return personManager.updatePerson(personTO);
        } catch (OrganizationException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

}
