
package org.ow2.dragon.service.sla;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.wsdl.AttachedDescription;

import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType;

@WebService
public interface SLAManagerService {

    
    @WebMethod(operationName = "importAgreementFromURI")
    String importAgreementDefFile(@WebParam(name = "agreementURI") String agreementURI) throws DragonFault;


    @WebMethod(operationName = "importAgreementFromAttachment")
    String importAgreementDefFile(
            @WebParam(name = "attachedAgreement") AttachedDescription attachedDescription)
            throws DragonFault;
   
    
    @WebMethod(operationName = "loadAgreementAsStringFromId")
    AgreementType loadAgreementFromId(@WebParam(name = "agreementId") String agreementId)
            throws DragonFault;

    @WebMethod(operationName = "loadAgreementAsAttachmentFromId")
    AttachedDescription loadAgreementAsAttachmentFromId(@WebParam(name = "agreementId") String agreementId)
            throws DragonFault;
    
    @WebMethod(operationName = "loadAllAgreementsAsStringFromService")
    List<AgreementType> loadAllAgreementsFromServiceId(@WebParam(name = "serviceId") String serviceId)
            throws DragonFault;

    @WebMethod(operationName = "loadAllAgreementsAsAttachmentFromService")
    List<AttachedDescription> loadAllAgreementsAsAttachmentFromServiceId(@WebParam(name = "serviceId") String serviceId)
            throws DragonFault;

    @WebMethod(operationName = "loadAllAgreementsAsStringFromEndpoint")
    List<AgreementType> loadAllAgreementsFromEndpointId(@WebParam(name = "endpointId") String endpointId)
            throws DragonFault;

    @WebMethod(operationName = "loadAllAgreementsAsAttachmentFromEndpoint")
    List<AttachedDescription> loadAllAgreementsAsAttachmentFromEndpointId(@WebParam(name = "endpointId") String endpointId)
            throws DragonFault;
    
    

}
