
package org.ow2.dragon.service.sla;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;
import javax.jws.WebService;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

import org.ow2.dragon.api.service.sla.SLAManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.wsdl.AttachedDescription;
import org.ow2.dragon.util.XMLUtil;
import org.w3c.dom.Document;

import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType;

@WebService(endpointInterface = "org.ow2.dragon.service.sla.SLAManagerService")
public class SLAManagerServiceImpl implements SLAManagerService {

    private SLAManager slaManager;

    private WSDLManager wsdlManager;
    
    private static JAXBContext jaxbContext;
    private static JAXBException jaxbException;

    static {
        try {
            jaxbContext = JAXBContext
            .newInstance(new Class[] {
                    com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ObjectFactory.class});
        } catch (JAXBException e) {
            jaxbException = e;
        }

    }

    public WSDLManager getWsdlManager() {
        return wsdlManager;
    }

    public void setWsdlManager(WSDLManager wsdlManager) {
        this.wsdlManager = wsdlManager;
    }

    public SLAManager getSlaManager() {
        return this.slaManager;
    }

    public void setSlaManager(final SLAManager manager) {
        this.slaManager = manager;
    }

    public String importAgreementDefFile(String agreementURI) throws DragonFault {
        String result = null;
        try {
            URI uri = URI.create(agreementURI);
            result = this.slaManager.importAgreementDefFile(uri);
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    public String importAgreementDefFile(AttachedDescription attachedDescription)
    throws DragonFault {
        String result = null;
        try {
            DataHandler desc = attachedDescription.getDescription();
            Document documentDesc = XMLUtil.loadDocument(desc.getInputStream());
            documentDesc.setDocumentURI(".");
            result = this.slaManager.importAgreementDefFile(documentDesc);
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    @Override
    public List<AttachedDescription> loadAllAgreementsAsAttachmentFromEndpointId(String endpointId)
    throws DragonFault {
        List<AttachedDescription> res = new ArrayList<AttachedDescription>();
        if(jaxbException != null) {
            throw new DragonFault(jaxbException.getMessage(), jaxbException);
        }
        try {
            List<ManagedAgreementTO> managedAgreementTos = this.slaManager.getAllManagedAgreementsFromEndpointId(endpointId);
            if (managedAgreementTos != null) {
                for(ManagedAgreementTO mag:  managedAgreementTos) {
                    InputStream inputStream = new ByteArrayInputStream(XMLPrettyPrinter.prettyPrint(WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(mag.getAgreement())).getBytes());
                    AttachedDescription agreement = new AttachedDescription();
                    agreement.setDescription(new DataHandler(new ByteArrayDataSource(inputStream,
                    "application/octet-stream")));
                    res.add(agreement);
                }
            }
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return res;
    }

    @Override
    public List<AttachedDescription> loadAllAgreementsAsAttachmentFromServiceId(String serviceId)
    throws DragonFault {
        List<AttachedDescription> res = new ArrayList<AttachedDescription>();
        if(jaxbException != null) {
            throw new DragonFault(jaxbException.getMessage(), jaxbException);
        }
        try {
            List<ManagedAgreementTO> managedAgreementTos = this.slaManager.getAllManagedAgreementsFromServiceId(serviceId);
            if (managedAgreementTos != null) {
                for(ManagedAgreementTO mag:  managedAgreementTos) {
                    InputStream inputStream = new ByteArrayInputStream(XMLPrettyPrinter.prettyPrint(WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(mag.getAgreement())).getBytes());
                    AttachedDescription agreement = new AttachedDescription();
                    agreement.setDescription(new DataHandler(new ByteArrayDataSource(inputStream,
                    "application/octet-stream")));
                    res.add(agreement);
                }
            }
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return res;
    }

    @Override
    public List<AgreementType> loadAllAgreementsFromEndpointId(String endpointId) throws DragonFault {
        List<AgreementType> res = new ArrayList<AgreementType>();
        if(jaxbException != null) {
            throw new DragonFault(jaxbException.getMessage(), jaxbException);
        }
        try {
            List<ManagedAgreementTO> managedAgreementTos = this.slaManager.getAllManagedAgreementsFromEndpointId(endpointId);
            if (managedAgreementTos != null) {
                for(ManagedAgreementTO mag:  managedAgreementTos) {
                    Document doc = WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(mag.getAgreement());
                    res.add((AgreementType) jaxbContext.createUnmarshaller().unmarshal(doc, AgreementType.class).getValue());
                }
            }
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return res;
    }

    @Override
    public List<AgreementType> loadAllAgreementsFromServiceId(String serviceId) throws DragonFault {
        List<AgreementType> res = new ArrayList<AgreementType>();
        if(jaxbException != null) {
            throw new DragonFault(jaxbException.getMessage(), jaxbException);
        }
        try {
            List<ManagedAgreementTO> managedAgreementTos = this.slaManager.getAllManagedAgreementsFromServiceId(serviceId);
            if (managedAgreementTos != null) {
                for(ManagedAgreementTO mag:  managedAgreementTos) {
                    Document doc = WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(mag.getAgreement());
                    res.add((AgreementType) jaxbContext.createUnmarshaller().unmarshal(doc, AgreementType.class).getValue());
                }
            }
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return res;
    }

    @Override
    public AttachedDescription loadAgreementAsAttachmentFromId(String agreementId)
    throws DragonFault {
        AttachedDescription agreement = new AttachedDescription();
        if(jaxbException != null) {
            throw new DragonFault(jaxbException.getMessage(), jaxbException);
        }
        try {
            ManagedAgreementTO managedAgreementTo = this.slaManager.getManagedAgreement(agreementId);
            if (managedAgreementTo != null) {
                InputStream inputStream = new ByteArrayInputStream(XMLPrettyPrinter.prettyPrint(WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(managedAgreementTo.getAgreement())).getBytes());
                agreement = new AttachedDescription();
                agreement.setDescription(new DataHandler(new ByteArrayDataSource(inputStream,
                "application/octet-stream")));
            }
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return agreement;
    }

    @Override
    public AgreementType loadAgreementFromId(String agreementId) throws DragonFault {
        AgreementType res = null;
        if(jaxbException != null) {
            throw new DragonFault(jaxbException.getMessage(), jaxbException);
        }
        try {
            ManagedAgreementTO managedAgreementTo = this.slaManager.getManagedAgreement(agreementId);
            if (managedAgreementTo != null) {
                Document doc = WSAgreementFactory.newInstance().newWSAgreementWriter().getDocument(managedAgreementTo.getAgreement());
                res = (AgreementType) jaxbContext.createUnmarshaller().unmarshal(doc, AgreementType.class).getValue();
            }
        } catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return res;
    }
}
