/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.technology;

import java.util.List;

import javax.jws.WebService;

import org.ow2.dragon.api.service.technology.TechnologyException;
import org.ow2.dragon.api.service.technology.TechnologyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecEnvManagerSearchProperties;
import org.ow2.dragon.api.to.technology.ExecEnvSearchProperties;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.FederationSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.service.DragonFault;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@WebService(endpointInterface = "org.ow2.dragon.service.technology.TechnologyManagerService")
public class TechnologyManagerServiceImpl implements TechnologyManagerService {

    private TechnologyManager technologyManager;

    public void setTechnologyManager(TechnologyManager technologyManager) {
        this.technologyManager = technologyManager;
    }

    public String addRuntimeManager(String address) throws DragonFault {
        try {
            return technologyManager.addRuntimeManager(address);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<EnvironmentFederationTO> getAllEnvironmentFederations(
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getAllEnvironmentFederations(requestOptionsTO);
    }

    public List<ExecutionEnvironmentManagerTO> getAllExecutionEnvironmentManagers(
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getAllExecutionEnvironmentManagers(requestOptionsTO);
    }

    public List<ExecutionEnvironmentTO> getAllExecutionEnvironments(
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getAllExecutionEnvironments(requestOptionsTO);
    }

    public List<ProcessorTO> getAllProcessors(RequestOptionsTO requestOptionsTO) {
        return technologyManager.getAllProcessors(requestOptionsTO);
    }

    public EnvironmentFederationTO getEnvironmentFederation(String envFedId) throws DragonFault {
        try {
            return technologyManager.getEnvironmentFederation(envFedId);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<EndpointTO> getEpsHostedOnExecEnv(String execEnvId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getEpsHostedOnExecEnv(execEnvId, requestOptionsTO);
    }

    public List<EndpointTO> getEpsHostedOnProcessor(String processorId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getEpsHostedOnProcessor(processorId, requestOptionsTO);
    }

    public List<ExecutionEnvironmentTO> getExecEnvsHostedOnProcessor(String processorId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getExecEnvsHostedOnProcessor(processorId, requestOptionsTO);
    }

    public List<ExecutionEnvironmentTO> getExecEnvsInFederation(String envFedId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getExecEnvsInFederation(envFedId, requestOptionsTO);
    }

    public ExecutionEnvironmentTO getExecutionEnvironment(String execEnvId) throws DragonFault {
        try {
            return technologyManager.getExecutionEnvironment(execEnvId);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<ExecutionEnvironmentTO> getManagedExecEnv(String runtimeManagerId,
            RequestOptionsTO requestOptionsTO) {
        return technologyManager.getManagedExecEnv(runtimeManagerId, requestOptionsTO);
    }

    public ProcessorTO getProcessor(String processorId) throws DragonFault {
        try {
            return technologyManager.getProcessor(processorId);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public ExecutionEnvironmentManagerTO getRuntimeManager(String runtimeManagerId)
            throws DragonFault {
        try {
            return technologyManager.getRuntimeManager(runtimeManagerId);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<EnvironmentFederationTO> searchEnvironmentFederations(String searchCriteria,
            List<FederationSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO)
            throws DragonFault {
        try {
            return technologyManager.searchEnvironmentFederations(searchCriteria,
                    searchedProperties, requestOptionsTO);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<ExecutionEnvironmentManagerTO> searchExecutionEnvironmentManagers(
            String searchCriteria, List<ExecEnvManagerSearchProperties> searchedProperties,
            RequestOptionsTO requestOptionsTO) throws DragonFault {
        try {
            return technologyManager.searchExecutionEnvironmentManagers(searchCriteria,
                    searchedProperties, requestOptionsTO);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<ExecutionEnvironmentTO> searchExecutionEnvironments(String searchCriteria,
            List<ExecEnvSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO)
            throws DragonFault {
        try {
            return technologyManager.searchExecutionEnvironments(searchCriteria,
                    searchedProperties, requestOptionsTO);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public List<ProcessorTO> searchProcessors(String searchCriteria,
            List<ProcessorSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO)
            throws DragonFault {
        try {
            return technologyManager.searchProcessors(searchCriteria, searchedProperties,
                    requestOptionsTO);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void synchronizeManagedExecEnv(String runtimeManagerId) throws DragonFault {
        try {
            technologyManager.synchronizeManagedExecEnv(runtimeManagerId);
        } catch (TechnologyException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

}
