package org.ow2.dragon.service.wsdm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.oasis_open.docs.wsn.bw_2.NotificationConsumer;
import org.ow2.dragon.api.service.wsdm.NotificationManager;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.dm.WSDMFactory;
import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;


@WebService(serviceName = "NotificationService", endpointInterface = "org.oasis_open.docs.wsn.bw_2.NotificationConsumer", targetNamespace = "http://dragon.ow2.org/service/wsdm")
@Transactional(readOnly = true)
public class WSDMNotificationServiceImpl implements NotificationConsumer {

    
    
    // create jaxb context
    static List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays.asList(new Class[] {
            org.oasis_open.docs.wsn.b_2.ObjectFactory.class}));
    
    static JAXBContext jaxbContext = null;
    static JAXBException jaxbexception = null;
    static org.oasis_open.docs.wsn.b_2.ObjectFactory cxfFactory = new org.oasis_open.docs.wsn.b_2.ObjectFactory();
    static DocumentBuilderFactory domfactory = null;

    static {
        try {
            jaxbContext = JAXBContext
   .newInstance(defaultObjectFactories.toArray(new Class[defaultObjectFactories.size()]));
            domfactory = DocumentBuilderFactory.newInstance();
            domfactory.setNamespaceAware(true);
        } catch (JAXBException e) {
            jaxbexception = e;
        }
    }
    
    private Logger logger = Logger.getLogger(this.getClass());
    
    
    private NotificationManager notificationManager;

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }
    
    public void setNotificationManager(final NotificationManager manager) {
        this.notificationManager = manager;
    }

    
    public WSDMNotificationServiceImpl() throws JAXBException {
        super();
        if(jaxbexception != null) {
            throw jaxbexception;
        }
    }
    
    public void notify(org.oasis_open.docs.wsn.b_2.Notify cxfNotify) {
        try {
            
            if(this.getNotificationManager() == null) {
                throw new WSDMException("wsdm Manager cannot be null!!!");
            }
            
            // convert cxf notify to ws star notify
            Document notifyDoc = domfactory.newDocumentBuilder().newDocument();
            jaxbContext.createMarshaller().marshal(cxfNotify, notifyDoc);
            com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify notify = WSNotificationReader.getInstance().readNotify(notifyDoc);
            
            if (notify != null) {
                
                /*
                 * Get producer reference
                 */
                String endpointRef = null;
                
                if(notify.getNotificationMessage() == null || notify.getNotificationMessage().size() > 1) {
                    throw new WSDMException("Sorry but a wsdm notification must have one notification message");
                }
                
                String producerReference = notify.getNotificationMessage().get(0).getProducerReference().getAddress();
                if(producerReference == null) {
                    throw new WSDMException("producer reference cannot be null!!!");
                }
                endpointRef = producerReference.replace("_WSDMMonitoring", "");
                
                final List<NotificationMessageHolderType> nmhtList = notify
                        .getNotificationMessage();
                if (nmhtList != null) {
                    for (final NotificationMessageHolderType nMHT : nmhtList) {
                        final Message msg = nMHT.getMessage();
                        if (msg != null) {
                            Document wsdmDoc = domfactory.newDocumentBuilder().newDocument();
                            wsdmDoc.appendChild(wsdmDoc.adoptNode(((Element)msg.getContent()).cloneNode(true)));
                                                        
                            final QoSMetrics metrics = WSDMFactory.newInstance().newWSDMReader()
                                    .readOperationMetric(wsdmDoc);

                            /*
                             * Get NotificationManager
                             */
                            this.getNotificationManager().handleNotification(metrics, endpointRef);

                        }
                    }
                }
            }
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            logger.error(e);
        } catch (JAXBException e) {
            e.printStackTrace();
            logger.error(e);
        } catch (WSNotificationException e) {
            e.printStackTrace();
            logger.error(e);
        } catch (DOMException e) {
            e.printStackTrace();
            logger.error(e);
        } catch (WSDMException e) {
            e.printStackTrace();
            logger.error(e);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
        }
        
    }
    

}
