/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import java.util.List;
import javax.jws.WebService;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.deployment.EndpointManagerService;

@WebService(endpointInterface="org.ow2.dragon.service.deployment.EndpointManagerService")
public class EndpointManagerServiceImpl
implements EndpointManagerService {
    private EndpointManager endpointManager;

    @Override
    public void addCategory(String endpointId, String categoryId, String categoryValue, String categoryDesc) throws DragonFault {
        try {
            this.endpointManager.addCategory(endpointId, categoryId, categoryValue, categoryDesc);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public void addCategory(String endpointId, String categoryId, String categoryValueId) throws DragonFault {
        try {
            this.endpointManager.addCategory(endpointId, categoryId, categoryValueId);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public List<EndpointTO> getAllEndpoints(RequestOptionsTO requestOptions) throws DragonFault {
        List result = null;
        try {
            result = this.endpointManager.getAllEndpoints(requestOptions);
        }
        catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public List<KeyedRefTO> getCategoriesForEndpoint(String endpointId) throws DragonFault {
        try {
            return this.endpointManager.getCategoriesForEndpoint(endpointId);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public EndpointTO getEndpoint(String endpointId) throws DragonFault {
        EndpointTO result = null;
        try {
            result = this.endpointManager.getEndpoint(endpointId, null);
        }
        catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public List<EndpointTO> getEndpointsByService(String serviceId, RequestOptionsTO requestOptions) throws DragonFault {
        List result = null;
        try {
            result = this.endpointManager.getEndpointsByTechService(serviceId, requestOptions);
        }
        catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public void removeCategories(String endpointId, List<String> categoryIds) throws DragonFault {
        try {
            this.endpointManager.removeCategories(endpointId, categoryIds);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public void removeEndpoint(String endpointId) throws DragonFault {
        try {
            this.endpointManager.removeEndpoint(endpointId);
        }
        catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public String updateEndpoint(EndpointTO endpointTO) throws DragonFault {
        try {
            return this.endpointManager.updateEndpoint(endpointTO);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    public void setEndpointManager(EndpointManager endpointManager) {
        this.endpointManager = endpointManager;
    }
}

