/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdm;

import com.ebmwebsourcing.wsstar.dm.WSDMFactory;
import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.oasis_open.docs.wsn.b_2.ObjectFactory;
import org.oasis_open.docs.wsn.bw_2.NotificationConsumer;
import org.ow2.dragon.api.service.wsdm.NotificationManager;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@WebService(serviceName="NotificationService", endpointInterface="org.oasis_open.docs.wsn.bw_2.NotificationConsumer", targetNamespace="http://dragon.ow2.org/service/wsdm")
@Transactional(readOnly=true)
public class WSDMNotificationServiceImpl
implements NotificationConsumer {
    static List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays.asList(ObjectFactory.class));
    static JAXBContext jaxbContext = null;
    static JAXBException jaxbexception = null;
    static ObjectFactory cxfFactory = new ObjectFactory();
    static DocumentBuilderFactory domfactory = null;
    private Logger logger = Logger.getLogger(this.getClass());
    private NotificationManager notificationManager;

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(NotificationManager manager) {
        this.notificationManager = manager;
    }

    public WSDMNotificationServiceImpl() throws JAXBException {
        if (jaxbexception != null) {
            throw jaxbexception;
        }
    }

    @Override
    public void notify(org.oasis_open.docs.wsn.b_2.Notify cxfNotify) {
        try {
            if (this.getNotificationManager() == null) {
                throw new WSDMException("wsdm Manager cannot be null!!!");
            }
            Document notifyDoc = domfactory.newDocumentBuilder().newDocument();
            jaxbContext.createMarshaller().marshal((Object)cxfNotify, (Node)notifyDoc);
            Notify notify = WSNotificationReader.getInstance().readNotify(notifyDoc);
            if (notify != null) {
                String endpointRef = null;
                if (notify.getNotificationMessage() == null || notify.getNotificationMessage().size() > 1) {
                    throw new WSDMException("Sorry but a wsdm notification must have one notification message");
                }
                String producerReference = ((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getProducerReference().getAddress();
                if (producerReference == null) {
                    throw new WSDMException("producer reference cannot be null!!!");
                }
                endpointRef = producerReference.replace("_WSDMMonitoring", "");
                List nmhtList = notify.getNotificationMessage();
                if (nmhtList != null) {
                    for (NotificationMessageHolderType nMHT : nmhtList) {
                        Message msg = nMHT.getMessage();
                        if (msg == null) continue;
                        Document wsdmDoc = domfactory.newDocumentBuilder().newDocument();
                        wsdmDoc.appendChild(wsdmDoc.adoptNode(msg.getContent().cloneNode(true)));
                        QoSMetrics metrics = WSDMFactory.newInstance().newWSDMReader().readOperationMetric(wsdmDoc);
                        this.getNotificationManager().handleNotification(metrics, endpointRef);
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
        }
        catch (WSNotificationException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
        }
        catch (DOMException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
        }
        catch (WSDMException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])defaultObjectFactories.toArray(new Class[defaultObjectFactories.size()]));
            domfactory = DocumentBuilderFactory.newInstance();
            domfactory.setNamespaceAware(true);
        }
        catch (JAXBException e) {
            jaxbexception = e;
        }
    }
}

