/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * MetadataManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.service.metadata;

import java.io.InputStream;
import java.net.URI;

import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.UDDIUseType;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Transactional
public interface MetadataService {

    void deleteMetadata(String metadataId);

    @Transactional(readOnly = true)
    byte[] loadMetadataContentAsBytes(String id);

    @Transactional(readOnly = true)
    InputStream loadMetadataContentAsInputStream(String id) throws MetadataServiceException;

    @Transactional(readOnly = true)
    SimpleFile loadMetadata(String id);

    SimpleFile storeMetadata(ContentType type, byte[] content) throws MetadataServiceException;

    SimpleFile storeMetadata(ContentType type, String fileCcontent) throws MetadataServiceException;

    SimpleFile storeMetadata(ContentType type, URI contentURI) throws MetadataServiceException;

    SimpleFile storeMetadataAndIndexContent(final ContentType type, final byte[] content)
            throws MetadataServiceException;

    SimpleFile storeMetadataAndIndexContent(final byte[] content) throws MetadataServiceException;

    SimpleFile storeMetadataAndIndexContent(String mimetype, byte[] docContent)
            throws MetadataServiceException;

    SimpleFile storeMetadata(ContentType type, byte[] content, String fileName)
            throws MetadataServiceException;

    SimpleFile storeMetadata(ContentType type, String fileCcontent, String fileName)
            throws MetadataServiceException;

    SimpleFile storeMetadata(ContentType type, URI contentURI, String fileName)
            throws MetadataServiceException;

    SimpleFile storeMetadata(ContentType type, URI contentURI, String fileName, UDDIUseType useType)
            throws MetadataServiceException;

    SimpleFile storeMetadata(final ContentType type, String fileContent, String fileName,
            UDDIUseType useType) throws MetadataServiceException;

    SimpleFile storeMetadataAndIndexContent(final ContentType type, final byte[] content,
            String fileName) throws MetadataServiceException;

    SimpleFile storeMetadataAndIndexContent(final byte[] content, String fileName)
            throws MetadataServiceException;

    SimpleFile storeMetadataAndIndexContent(String mimetype, byte[] docContent, String fileName)
            throws MetadataServiceException;

    void cleanupRepository();

    @Transactional(readOnly = true)
    String getRepositoryRootPath();
}
