/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PartyManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.service.organization;

import java.util.List;

import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PartyTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.springframework.transaction.annotation.Transactional;

/**
 * A manager of parties. Provides methods to create, retrieve, delete or update
 * parties. Method arguments must be non null, unless the contrary is explicitly
 * specified.
 * 
 * @author ambarthe, ofabre - eBM WebSourcing
 * 
 */
@Transactional
public interface PartyManager {

    /**
     * Return the list of all parties in the registry, persons and organization
     * units
     * 
     * @param requestOptionsTO
     *            sort, pagination and case sensitive parameters, could be null
     * @return the {@link List} of all parties in the registry, {@link PersonTO}
     *         s and {@link OrganizationUnitTO}s. Can't be null, could be empty
     */
    @Transactional(readOnly = true)
    public List<PartyTO> getAllParties(RequestOptionsTO requestOptionsTO);

    /**
     * Retrieve a party matching the given ID. Could be a person or an
     * organization unit
     * 
     * @param partyId
     *            a party ID
     * @return a party matching the given ID. Can be a {@link PersonTO} or an
     *         {@link OrganizationUnitTO}. Can't be null, could be empty
     * @throws OrganizationException
     *             if no party found for the given id
     */
    @Transactional(readOnly = true)
    public PartyTO getParty(String partyId) throws OrganizationException;

}
