/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RequestOptionsTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to;


/**
 * Defines options for requesting DragonDataBase.
 * <p>
 * This allows defining "sort", "pagination" and "case sensitive" options when
 * requesting the DragonDataBase
 * </p>
 * 
 * @author ofabre - eBM Websourcing
 */
public class RequestOptionsTO {
    private int firstResult = 0;

    private int nbOfResults = Integer.MAX_VALUE;

    private SortCriteria sortCriteria = null;

    private boolean sortAscendingly = true;

    private boolean caseSensitive = false;

    /**
     * Returns the requested first result index.
     * <p>
     * This the pagination offset
     * </p>
     * 
     * @return
     */
    public int getFirstResult() {
        return this.firstResult;
    }

    /**
     * Returns the requested number of results.
     * <p>
     * This the pagination length
     * </p>
     * 
     * @return
     */
    public int getNbOfResults() {
        return this.nbOfResults;
    }

    /**
     * Returns the sort criteria ID
     * 
     * @return
     */
    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    /**
     * Determines whether pagination options are set
     * 
     * @return
     */
    public boolean hasPagination() {
        return this.nbOfResults != Integer.MAX_VALUE;
    }

    /**
     * Determines whether sort options are set
     * 
     * @return
     */
    public boolean hasSortOption() {
        return this.sortCriteria != null;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /**
     * Determines whether sort is ascending.
     * 
     * @return
     */
    public boolean isSortAscendingly() {
        return this.sortAscendingly;
    }

    public void setCaseSensitive(final boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    /**
     * Sets the requested first result index.
     * 
     * @param firstResult
     */
    public void setFirstResult(final int firstResult) {
        this.firstResult = firstResult;
    }

    /**
     * Sets the requested number of results.
     * 
     * @param nbOfResults
     */
    public void setNbOfResults(final int nbOfResults) {
        this.nbOfResults = nbOfResults;
    }

    /**
     * Sets whether sort is ascending.
     * 
     * @param sortAscendingly
     */
    public void setSortAscendingly(final boolean sortAscendingly) {
        this.sortAscendingly = sortAscendingly;
    }

    /**
     * Sets the sort criteria ID
     * 
     * @param sortColumn
     */
    public void setSortCriteria(final SortCriteria sortColumn) {
        this.sortCriteria = sortColumn;
    }

}
