/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CategoryValueTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.common;

/**
 * @author ofabre
 * 
 */
public class CategoryValueTO {

    private String id;

    private String value;

    private String description;

    public CategoryValueTO() {
        super();
    }

    public CategoryValueTO(String id, String value, String description) {
        super();
        this.id = id;
        this.value = value;
        this.description = description;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValueAndDesc() {
        StringBuffer result = new StringBuffer();

        result.append(value);

        if (description != null) {
            result.append(" - ");
            if (description.length() > 60) {
                result.append(description.substring(0, 56));
                result.append("...");
            } else {
                result.append(description);
            }
        }
        return result.toString();
    }

}
