/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * BindingTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.deployment;

import java.util.List;
import java.util.Set;

import org.ow2.dragon.api.to.specification.ServiceInterfaceTO;

/**
 * This type provides technical information (communication protocols) describing
 * a way to call a service
 * 
 * @author ambarthe - eBM WebSourcing
 * 
 */

public class BindingTO {

    private String id;

    private String name;

    private ServiceInterfaceTO serviceInterface;

    private Set<ProtocolTO> protocols;

    private Set<TransportTO> transports;

    private List<BindingOperationTO> bindingOps;

    public List<BindingOperationTO> getBindingOps() {
        return this.bindingOps;
    }

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    public ServiceInterfaceTO getServiceInterface() {
        return this.serviceInterface;
    }

    public void setBindingOps(final List<BindingOperationTO> bindingOps) {
        this.bindingOps = bindingOps;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    public void setServiceInterface(final ServiceInterfaceTO serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public Set<ProtocolTO> getProtocols() {
        return protocols;
    }

    public void setProtocols(Set<ProtocolTO> protocols) {
        this.protocols = protocols;
    }

    public Set<TransportTO> getTransports() {
        return transports;
    }

    public void setTransports(Set<TransportTO> transports) {
        this.transports = transports;
    }

}
