/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * StandardTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.deployment;

/**
 * This type gives a description of a standard like WS standards (SOAP etc.)
 * 
 * @author ambarthe - eBM WebSourcing
 * 
 */

public class StandardTO {
    /*
     * Attributes
     */
    private String id;

    private String name;

    private String category;

    private String releaseNr;

    private String originating;

    private String location;

    private String notes;

    /*
     * Getters and setters
     */

    /**
     * @return the category
     */
    public String getCategory() {
        return this.category;
    }

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the location
     */
    public String getLocation() {
        return this.location;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the notes
     */
    public String getNotes() {
        return this.notes;
    }

    /**
     * @return the originating
     */
    public String getOriginating() {
        return this.originating;
    }

    /**
     * @return the releaseNr
     */
    public String getReleaseNr() {
        return this.releaseNr;
    }

    /**
     * @param category
     *            the category to set
     */
    public void setCategory(final String category) {
        this.category = category;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param location
     *            the location to set
     */
    public void setLocation(final String location) {
        this.location = location;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * @param notes
     *            the notes to set
     */
    public void setNotes(final String notes) {
        this.notes = notes;
    }

    /**
     * @param originating
     *            the originating to set
     */
    public void setOriginating(final String originating) {
        this.originating = originating;
    }

    /**
     * @param releaseNr
     *            the releaseNr to set
     */
    public void setReleaseNr(final String releaseNr) {
        this.releaseNr = releaseNr;
    }

}
