/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrgToEndpointTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.organization;

import org.ow2.dragon.api.to.deployment.EndpointTO;

/**
 * This type represents a role of an {@link OrganizationUnitTO} against an
 * {@link EndpointTO}
 * 
 * @author ofabre - eBM WebSourcing
 * 
 */
public class OrgToEndpointTO extends RoleOfPartyTO {

    private EndpointTO endpointTO;

    public EndpointTO getEndpointTO() {
        return this.endpointTO;
    }

    public OrganizationUnitTO getOrganizationUnitTO() {
        return (OrganizationUnitTO) this.getPartyTO();
    }

    public void setEndpointTO(final EndpointTO endpointTO) {
        this.endpointTO = endpointTO;
    }

}
