/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationUnitTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.organization;

import java.util.List;

import org.ow2.dragon.api.to.common.KeyedRefTO;

/**
 * 
 * This type gives the description of an organization.
 * 
 * @author ambarthe - eBM WebSourcing
 */
public class OrganizationUnitTO extends PartyTO {
    // ==========================================================
    // === Attributes
    // ==========================================================

    private String name;

    private String type;

    private boolean isLegalEntity;

    private String discoveryURL;

    private String emailAddress;

    private String streetNumber;

    private String street;

    private String complement;

    private String zipcode;

    private String city;

    private String state;

    private String country;

    private OrganizationUnitTO motherOrganization;

    private List<KeyedRefTO> identifiers;

    private List<KeyedRefTO> categories;

    /*
     * Getters and setters
     */

    /**
     * @return the city
     */
    public String getCity() {
        return this.city;
    }

    /**
     * @return the complement
     */
    public String getComplement() {
        return this.complement;
    }

    /**
     * @return the country
     */
    public String getCountry() {
        return this.country;
    }

    /**
     * @return the discoveryURL
     */
    public String getDiscoveryURL() {
        return this.discoveryURL;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    /**
     * @return the isLegalEntity
     */
    public boolean getIsLegalEntity() {
        return this.isLegalEntity;
    }

    /**
     * @return the motherOrganization
     */
    public OrganizationUnitTO getMotherOrganization() {
        return this.motherOrganization;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    public String getNameAndCity() {
        String result = null;
        if (this.city != null) {
            result = this.name + " (" + this.city + ")";
        } else {
            result = this.name;
        }
        return result;
    }

    /**
     * @return the state
     */
    public String getState() {
        return this.state;
    }

    /**
     * @return the street
     */
    public String getStreet() {
        return this.street;
    }

    /**
     * @return the streetNumber
     */
    public String getStreetNumber() {
        return this.streetNumber;
    }

    /**
     * @return the type
     */
    public String getType() {
        return this.type;
    }

    /**
     * @return the zipcode
     */
    public String getZipcode() {
        return this.zipcode;
    }

    /**
     * @param city
     *            the city to set
     */
    public void setCity(final String city) {
        this.city = city;
    }

    /**
     * @param complement
     *            the complement to set
     */
    public void setComplement(final String complement) {
        this.complement = complement;
    }

    /**
     * @param country
     *            the country to set
     */
    public void setCountry(final String country) {
        this.country = country;
    }

    /**
     * @param discoveryURLs
     *            the discoveryURLs to set
     */
    public void setDiscoveryURL(final String discoveryURL) {
        this.discoveryURL = discoveryURL;
    }

    public void setEmailAddress(final String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * @param isLegalEntity
     *            the isLegalEntity to set
     */
    public void setIsLegalEntity(final boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
    }

    /**
     * @param motherOrganization
     *            the motherOrganization to set
     */
    public void setMotherOrganization(final OrganizationUnitTO motherOrganization) {
        this.motherOrganization = motherOrganization;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * @param state
     *            the state to set
     */
    public void setState(final String state) {
        this.state = state;
    }

    /**
     * @param street
     *            the street to set
     */
    public void setStreet(final String street) {
        this.street = street;
    }

    /**
     * @param streetNumber
     *            the streetNumber to set
     */
    public void setStreetNumber(final String streetNumber) {
        this.streetNumber = streetNumber;
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType(final String type) {
        this.type = type;
    }

    /**
     * @param zipcode
     *            the zipcode to set
     */
    public void setZipcode(final String zipcode) {
        this.zipcode = zipcode;
    }

    public List<KeyedRefTO> getIdentifiers() {
        return identifiers;
    }

    public void setIdentifiers(List<KeyedRefTO> identifiers) {
        this.identifiers = identifiers;
    }

    public List<KeyedRefTO> getCategories() {
        return categories;
    }

    public void setCategories(List<KeyedRefTO> categories) {
        this.categories = categories;
    }

}
