/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ManagedAgreementTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.sla;

import java.util.Date;

import com.ebmwebsourcing.agreement.definition.api.Agreement;

/**
 * 
 * @author ofabre - eBM Websourcing
 *
 */
public class ManagedAgreementTO {


    private Agreement agreement;

    protected String id = "-1";

    private String slaDescription;

    private String clientId;

    private String providerId;
    
    private String state;

    /**
     * @return the a
     */
    public Agreement getAgreement() {
        return this.agreement;
    }


    /**
     * 
     * 
     * @return possible object is {@link Long }
     * 
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the client
     */
    public String getIdClient() {
        return this.clientId;
    }

    /**
     * @return the provider
     */
    public String getIdProvider() {
        return this.providerId;
    }


    /**
     * @return the slaDescription
     */
    public String getSlaDescription() {
        return this.slaDescription;
    }


    /**
     * @param a
     *            the a to set
     */
    public void setAgreement(final Agreement a) {
        this.agreement = a;
    }


    /**
     * 
     * 
     * @param value
     *            allowed object is {@link Long }
     * 
     */
    public void setId(final String value) {
        this.id = value;
    }

    /**
     * @param client
     *            the client to set
     */
    public void setIdClient(final String client) {
        this.clientId = client;
    }

    /**
     * @param provider
     *            the provider to set
     */
    public void setIdProvider(final String provider) {
        this.providerId = provider;
    }


    /**
     * @param slaDescription
     *            the slaDescription to set
     */
    public void setSlaDescription(final String slaDescription) {
        this.slaDescription = slaDescription;
    }


	public String getState() {
		return state;
	}


	public void setState(String state) {
		this.state = state;
	}

}
