/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * MessageSpecificationTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.specification;

/**
 * A Message Specification is the representation of a XML messages exchanged as
 * input or output of a Specified operation
 * 
 * @author ambarthe - eBM WebSourcing
 * 
 */

public class MessageSpecificationTO {
    // ==========================================================
    // === Attributes
    // ==========================================================
    private SpecifiedOperationTO operation;

    private String id;

    private String role;

    private String structure;

    /*
     * Getters and setters
     */

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the operation
     */
    public SpecifiedOperationTO getOperation() {
        return this.operation;
    }

    /**
     * @return the role
     */
    public String getRole() {
        return this.role;
    }

    /**
     * @return the structure
     */
    public String getStructure() {
        return this.structure;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param operation
     *            the operation to set
     */
    public void setOperation(final SpecifiedOperationTO operation) {
        this.operation = operation;
    }

    /**
     * @param role
     *            the role to set
     */
    public void setRole(final String role) {
        this.role = role;
    }

    /**
     * @param structure
     *            the structure to set
     */
    public void setStructure(final String structure) {
        this.structure = structure;
    }

}
