/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceSpecificationTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.specification;

/**
 * A Service Specification is a description of a Service (aka WSDL)
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class ServiceSpecificationTO {

    // ==========================================================
    // === Attributes
    // ==========================================================
    private VersionedSpecificationTO versionedSpec;

    private String id;

    private String name;

    private String purpose;

    private String category;

    private String interfaceStyle;

    private String alias;

    private String visibility;

    private String otherInfo;
    
    private String fileName;

    /*
     * Getters and setters
     */

    /**
     * @return the alias
     */
    public String getAlias() {
        return this.alias;
    }

    /**
     * @return the category
     */
    public String getCategory() {
        return this.category;
    }

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the interfaceStyle
     */
    public String getInterfaceStyle() {
        return this.interfaceStyle;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the otherInfo
     */
    public String getOtherInfo() {
        return this.otherInfo;
    }

    /**
     * @return the purpose
     */
    public String getPurpose() {
        return this.purpose;
    }

    /**
     * @return the versionedSpec
     */
    public VersionedSpecificationTO getVersionedSpec() {
        return this.versionedSpec;
    }

    /**
     * @return the visibility
     */
    public String getVisibility() {
        return this.visibility;
    }

    /**
     * @param alias
     *            the alias to set
     */
    public void setAlias(final String alias) {
        this.alias = alias;
    }

    /**
     * @param category
     *            the category to set
     */
    public void setCategory(final String category) {
        this.category = category;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param interfaceStyle
     *            the interfaceStyle to set
     */
    public void setInterfaceStyle(final String interfaceStyle) {
        this.interfaceStyle = interfaceStyle;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * @param otherInfo
     *            the otherInfo to set
     */
    public void setOtherInfo(final String otherInfo) {
        this.otherInfo = otherInfo;
    }

    /**
     * @param purpose
     *            the purpose to set
     */
    public void setPurpose(final String purpose) {
        this.purpose = purpose;
    }

    /**
     * @param versionedSpec
     *            the versionedSpec to set
     */
    public void setVersionedSpec(final VersionedSpecificationTO versionedSpec) {
        this.versionedSpec = versionedSpec;
    }

    /**
     * @param visibility
     *            the visibility to set
     */
    public void setVisibility(final String visibility) {
        this.visibility = visibility;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

}
