/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EnvironmentFederationTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.technology;

import java.util.List;

/**
 * A Federation is group of linked Execution Environments. Examples of
 * Federation: Federated or Distributed ESB, Grid, etc.
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class EnvironmentFederationTO {

    private String envFedId;

    private String name;

    private String pattern;

    private List<String> possibleRole;

    public String getEnvFedId() {
        return this.envFedId;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<String> getPossibleRole() {
        return this.possibleRole;
    }

    public void setEnvFedId(final String envFedId) {
        this.envFedId = envFedId;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setPattern(final String pattern) {
        this.pattern = pattern;
    }

    public void setPossibleRole(final List<String> possibleRole) {
        this.possibleRole = possibleRole;
    }

}
