/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CommunityObj.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.compass.annotations.Searchable;
import org.hibernate.annotations.CollectionOfElements;

/**
 * @author atiar (Abderrahmane TIAR)
 * 
 */

@Entity(name = "org.ow2.dragon.persistence.bo.common.CommunityObj")
@Inheritance(strategy = InheritanceType.JOINED)
@Searchable(root = false)
public class CommunityObj extends LinkedEntity {

    /**
     * 
     */
    private static final long serialVersionUID = -173407239562343951L;

    private Set<Rating> ratings;

    private List<Comment> comments;

    private Set<String> tags;

    public CommunityObj() {
        super();
        ratings = new HashSet<Rating>();
        comments = new ArrayList<Comment>();
        tags = new HashSet<String>();
    }

    @OneToMany(cascade = CascadeType.ALL)
    public Set<Rating> getRatings() {
        return ratings;
    }

    public void setRatings(Set<Rating> ratings) {
        this.ratings = ratings;
    }

    @OneToMany(cascade = CascadeType.ALL)
    public List<Comment> getComments() {
        return comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    @CollectionOfElements
    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public boolean isTagged(String tag) {
        return this.tags.contains(tag);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(ratings).append(comments).append(tags).toHashCode();
    }
}
