/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TModel.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.common.TModel")
@Inheritance(strategy = InheritanceType.JOINED)
@Searchable(root = false)
public class TModel extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -6401150800678521372L;

    private Timestamp version;

    @SearchableComponent
    private Name name;

    private boolean deleted;

    @SearchableComponent
    private List<Description> descriptions;

    private List<SimpleFile> overviewDocs;

    public TModel(Name name, boolean deleted, List<Description> descriptions,
            List<SimpleFile> overviewDocs, List<KeyedReference> identifierBag,
            CategoryBag categoryBag) {
        super();
        this.name = name;
        this.deleted = deleted;
        if (descriptions != null) {
            this.descriptions = descriptions;
        } else {
            this.descriptions = new ArrayList<Description>();
        }
        if (overviewDocs != null) {
            this.overviewDocs = overviewDocs;
        } else {
            this.overviewDocs = new ArrayList<SimpleFile>();
        }
        if (identifierBag != null) {
            this.identifierBag = identifierBag;
        } else {
            this.identifierBag = new ArrayList<KeyedReference>();
        }
        this.categoryBag = categoryBag;
    }

    private List<KeyedReference> identifierBag;

    private CategoryBag categoryBag;

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof TModel))
            return false;
        TModel castOther = (TModel) other;
        return new EqualsBuilder().append(name, castOther.name).append(descriptions,
                castOther.descriptions).append(identifierBag, castOther.identifierBag).append(
                categoryBag, castOther.categoryBag).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(descriptions).append(identifierBag)
                .append(categoryBag).toHashCode();
    }

    public TModel() {
        this.descriptions = new ArrayList<Description>();
        this.overviewDocs = new ArrayList<SimpleFile>();
        this.identifierBag = new ArrayList<KeyedReference>();
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addOverviewDoc(SimpleFile overviewDoc) {
        this.getOverviewDocs().add(overviewDoc);
    }

    public void addIdentifier(KeyedReference identifier) {
        this.getIdentifierBag().add(identifier);
    }

    @OneToOne(cascade = CascadeType.ALL)
    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Description> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<SimpleFile> getOverviewDocs() {
        return overviewDocs;
    }

    public void setOverviewDocs(List<SimpleFile> overviewDocs) {
        this.overviewDocs = overviewDocs;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<KeyedReference> getIdentifierBag() {
        return identifierBag;
    }

    public void setIdentifierBag(List<KeyedReference> identifierBag) {
        this.identifierBag = identifierBag;
    }

    @OneToOne(cascade = CascadeType.ALL)
    public CategoryBag getCategoryBag() {
        return categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("deleted",
                this.deleted).append("descriptions", this.descriptions).append("categoryBag",
                this.categoryBag).append("identifierBag", this.identifierBag).append(
                "overviewDocs", this.overviewDocs).append("name", this.name).toString();
    }

    @Version
    public Timestamp getVersion() {
        return version;
    }

    public void setVersion(Timestamp version) {
        this.version = version;
    }

}
