/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Endpoint.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CommunityObj;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.technology.Node;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.deployment.Endpoint")
@Searchable(root = false)
public class Endpoint extends CommunityObj implements Comparable<Endpoint> {

    /**
     * 
     */
    private static final long serialVersionUID = -2024620472026451233L;

    @SearchableComponent
    private Binding binding;

    private String name;

    private String networkAddress;

    private TechnicalService technicalService;

    private Set<ServiceSpecification> serviceSpecifications;

    private Node hostNode;

    // UDDI fields
    @SearchableComponent
    private List<Description> descriptions;

    @SearchableComponent
    private CategoryBag categoryBag;

    public Endpoint() {
        super();
        this.descriptions = new ArrayList<Description>();
        this.serviceSpecifications = new HashSet<ServiceSpecification>();
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addServiceSpec(ServiceSpecification serviceSpecification) {
        this.getServiceSpecifications().add(serviceSpecification);
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Endpoint))
            return false;
        Endpoint castOther = (Endpoint) other;
        return new EqualsBuilder().append(name, castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).toHashCode();
    }

    @ManyToOne
    @JoinColumn(name = "nodeId")
    public Node getHostNode() {
        return hostNode;
    }

    public void setHostNode(Node hostNode) {
        this.hostNode = hostNode;
    }

    @ManyToOne
    @JoinColumn(name = "bindingId", nullable = false)
    public Binding getBinding() {
        return this.binding;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @ManyToOne
    @JoinColumn(name = "technicalServiceId", nullable = false)
    public TechnicalService getTechnicalService() {
        return this.technicalService;
    }

    public void setBinding(final Binding binding) {
        this.binding = binding;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setNetworkAddress(final String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public void setTechnicalService(final TechnicalService technicalService) {
        this.technicalService = technicalService;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("networkAddress", this.networkAddress).append("binding",
                this.binding).append("name", this.name).toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(final Endpoint other) {
        return new CompareToBuilder().append(name, other.name).toComparison();
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Description> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToOne(cascade = CascadeType.ALL)
    public CategoryBag getCategoryBag() {
        return categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    @ManyToMany
    public Set<ServiceSpecification> getServiceSpecifications() {
        return serviceSpecifications;
    }

    public void setServiceSpecifications(Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

}
