/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Party.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.organization;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.LinkedEntity;
import org.ow2.dragon.persistence.bo.common.Name;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.organization.Party")
@Inheritance(strategy = InheritanceType.JOINED)
@Searchable(root = false)
public class Party extends LinkedEntity {

    /**
     * 
     */
    private static final long serialVersionUID = 4264025768507516327L;

    @SearchableComponent
    private List<Description> descriptions;

    private List<Email> emailAddresses;

    private boolean isExternal;

    @SearchableComponent
    private List<Name> names;

    private OrganizationUnit parentOrganization;

    private String responsabilities;

    private List<Address> addresses;

    public Party() {
        super();
        this.names = new ArrayList<Name>();
        this.descriptions = new ArrayList<Description>();
        this.emailAddresses = new ArrayList<Email>();
        this.addresses = new ArrayList<Address>();
    }

    public void addAddress(final Address address) {
        this.getAddresses().add(address);
    }

    public void addEmail(final Email email) {
        this.getEmailAddresses().add(email);
    }

    public void addDescription(final Description description) {
        this.getDescriptions().add(description);
    }

    public void addName(final Name name) {
        this.getNames().add(name);
    }

    @OneToMany(cascade = CascadeType.ALL)
    @OrderBy("name ASC")
    @SearchableComponent
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Name> getNames() {
        return this.names;
    }

    @ManyToOne
    @SearchableComponent
    public OrganizationUnit getParentOrganization() {
        return this.parentOrganization;
    }

    public String getResponsabilities() {
        return this.responsabilities;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(final boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setNames(final List<Name> name) {
        this.names = name;
    }

    public void setParentOrganization(final OrganizationUnit parentOrganization) {
        this.parentOrganization = parentOrganization;
    }

    public void setResponsabilities(final String responsabilities) {
        this.responsabilities = responsabilities;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Description> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Email> getEmailAddresses() {
        return emailAddresses;
    }

    public void setEmailAddresses(List<Email> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    @SearchableComponent
    public List<Address> getAddresses() {
        return addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Party))
            return false;
        Party castOther = (Party) other;
        return new EqualsBuilder().append(names, castOther.names).append(addresses,
                castOther.addresses).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(names).append(addresses).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("addresses", this.addresses).append("isExternal",
                this.isExternal).append("descriptions", this.descriptions).append(
                "responsabilities", this.responsabilities).append("names", this.names).append(
                "emailAddresses", this.emailAddresses).toString();
    }

}
