/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Person.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.organization;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cascade;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.organization.Person")
@Searchable
public class Person extends Party {

    /**
     * 
     */
    private static final long serialVersionUID = -1325593703523178955L;

    private String firstName;

    private String lastName;

    private String location;

    private String middleName;

    @SearchableComponent
    private List<PhoneNumber> phoneNumbers;

    private Post post;

    private String title;

    private boolean contact;

    public Person() {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
    }

    public void addPhoneNumber(final PhoneNumber phoneNumber) {
        this.getPhoneNumbers().add(phoneNumber);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Person)) {
            return false;
        }
        final Person castOther = (Person) other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.firstName,
                castOther.firstName).append(this.lastName, castOther.lastName).append(
                this.getEmailAddresses(), castOther.getEmailAddresses()).isEquals();
    }

    @SearchableProperty
    public String getFirstName() {
        return this.firstName;
    }

    @SearchableProperty
    public String getLastName() {
        return this.lastName;
    }

    public String getLocation() {
        return this.location;
    }

    @SearchableProperty
    public String getMiddleName() {
        return this.middleName;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @ManyToOne
    @SearchableComponent
    public Post getPost() {
        return this.post;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.firstName).append(
                this.lastName).toHashCode();
    }

    public void setFirstName(final String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(final String lastName) {
        this.lastName = lastName;
    }

    public void setLocation(final String location) {
        this.location = location;
    }

    public void setMiddleName(final String middleName) {
        this.middleName = middleName;
    }

    public void setPhoneNumbers(final List<PhoneNumber> phoneNumber) {
        this.phoneNumbers = phoneNumber;
    }

    public void setPost(final Post post) {
        this.post = post;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("title", this.title).append("posts", this.post).append(
                "phoneNumbers", this.phoneNumbers).append("middleName", this.middleName).append(
                "location", this.location).append("firstName", this.firstName).append("lastName",
                this.lastName).append("contact", this.contact).toString();
    }

    public boolean isContact() {
        return contact;
    }

    public void setContact(boolean contact) {
        this.contact = contact;
    }

}
