/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ProposedOperation.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.service;

import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.common.NonSearchableBaseObject;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.service.ProposedOperation")
public class ProposedOperation extends NonSearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -8950386484183331208L;

    private String name;

    private String notes;

    private String parameters;

    private String purpose;

    private Service service;

    public String getName() {
        return this.name;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getPurpose() {
        return this.purpose;
    }

    @ManyToOne
    @JoinColumn(name = "serviceId", nullable = false)
    public Service getService() {
        return this.service;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setNotes(final String notes) {
        this.notes = notes;
    }

    public void setParameters(final String parameters) {
        this.parameters = parameters;
    }

    public void setPurpose(final String purpose) {
        this.purpose = purpose;
    }

    public void setService(final Service service) {
        this.service = service;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof ProposedOperation))
            return false;
        ProposedOperation castOther = (ProposedOperation) other;
        return new EqualsBuilder().append(name, castOther.name).append(parameters,
                castOther.parameters).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(parameters).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("purpose",
                this.purpose).append("service", this.service).append("parameters", this.parameters)
                .append("notes", this.notes).append("name", this.name).toString();
    }

}
