/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Service.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.service.Service")
@Searchable(root = false)
public class Service extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 6423683917036741837L;

    public enum Visibility {
        CUSTOMERS, ENTERPRISE_INTERNAL, ORG_UNIT_INTERNAL, PARTITION_INTERNAL,
        PARTNER_ORGANIZATIONS, PUBLIC, SPECIFIC_CUSTOMERS, SPECIFIC_PARTNERS
    }

    public enum XfaceStyle {
        DIGITAL, DUAL, NONDIGITAL, UNDECIDED
    }

    private Set<String> alias;

    private Set<String> criticalSuccessFactors;

    private String infoProcessingStyle;

    private String intendedImplementationStyle;

    private XfaceStyle interfaceStyle;

    private boolean isBusinessService;

    private Set<String> nonFunctionalRqmts;

    private Set<ProposedOperation> proposedOps;

    private String responsabilities;

    private String stabilityExpectations;

    private Set<String> targetCustomers;

    private Set<TechnicalService> technicalServices;

    private Visibility visibility;

    // UDDI fields
    private String uddiKey;

    @SearchableComponent
    private List<Name> names;

    @SearchableComponent
    private List<Description> descriptions;

    // Fields replaced by the generic field : descriptions
    // private String purpose;
    // private String otherInformation;

    @SearchableComponent
    private CategoryBag categoryBag;

    public Service() {
        this.technicalServices = new HashSet<TechnicalService>();
        this.proposedOps = new HashSet<ProposedOperation>();
        this.names = new ArrayList<Name>();
        this.descriptions = new ArrayList<Description>();
    }

    public void addDescription(final Description description) {
        this.getDescriptions().add(description);
    }

    public void addName(final Name name) {
        this.getNames().add(name);
    }

    public void addProposedOperation(final ProposedOperation proposedOperation) {
        this.getProposedOps().add(proposedOperation);
        proposedOperation.setService(this);
    }

    public void addTechnicalService(final TechnicalService technicalService) {
        this.getTechnicalServices().add(technicalService);
        technicalService.setService(this);
    }

    @CollectionOfElements
    public Set<String> getAlias() {
        return this.alias;
    }

    @CollectionOfElements
    public Set<String> getCriticalSuccessFactors() {
        return this.criticalSuccessFactors;
    }

    public String getInfoProcessingStyle() {
        return this.infoProcessingStyle;
    }

    public String getIntendedImplementationStyle() {
        return this.intendedImplementationStyle;
    }

    @Enumerated(EnumType.STRING)
    public XfaceStyle getInterfaceStyle() {
        return this.interfaceStyle;
    }

    @CollectionOfElements
    public Set<String> getNonFunctionalRqmts() {
        return this.nonFunctionalRqmts;
    }

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "service")
    public Set<ProposedOperation> getProposedOps() {
        return this.proposedOps;
    }

    public String getResponsabilities() {
        return this.responsabilities;
    }

    public String getStabilityExpectations() {
        return this.stabilityExpectations;
    }

    @CollectionOfElements
    public Set<String> getTargetCustomers() {
        return this.targetCustomers;
    }

    @OneToMany(mappedBy = "service")
    public Set<TechnicalService> getTechnicalServices() {
        return this.technicalServices;
    }

    @Enumerated(EnumType.STRING)
    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isBusinessService() {
        return this.isBusinessService;
    }

    public void setAlias(final Set<String> alias) {
        this.alias = alias;
    }

    public void setBusinessService(final boolean isBusinessService) {
        this.isBusinessService = isBusinessService;
    }

    public void setCriticalSuccessFactors(final Set<String> criticalSuccessFactors) {
        this.criticalSuccessFactors = criticalSuccessFactors;
    }

    public void setInfoProcessingStyle(final String infoProcessingStyle) {
        this.infoProcessingStyle = infoProcessingStyle;
    }

    public void setIntendedImplementationStyle(final String intendedImplementationStyle) {
        this.intendedImplementationStyle = intendedImplementationStyle;
    }

    public void setInterfaceStyle(final XfaceStyle interfaceStyle) {
        this.interfaceStyle = interfaceStyle;
    }

    public void setNonFunctionalRqmts(final Set<String> nonFunctionalRqmts) {
        this.nonFunctionalRqmts = nonFunctionalRqmts;
    }

    public void setProposedOps(final Set<ProposedOperation> proposedOps) {
        this.proposedOps = proposedOps;
    }

    public void setResponsabilities(final String responsabilities) {
        this.responsabilities = responsabilities;
    }

    public void setStabilityExpectations(final String stabilityExpectations) {
        this.stabilityExpectations = stabilityExpectations;
    }

    public void setTargetCustomers(final Set<String> targetCustomers) {
        this.targetCustomers = targetCustomers;
    }

    public void setTechnicalServices(final Set<TechnicalService> technicalServices) {
        this.technicalServices = technicalServices;
    }

    public void setVisibility(final Visibility visibility) {
        this.visibility = visibility;
    }

    public String getUddiKey() {
        return uddiKey;
    }

    public void setUddiKey(String uddiKey) {
        this.uddiKey = uddiKey;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Name> getNames() {
        return names;
    }

    public void setNames(List<Name> names) {
        this.names = names;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Description> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    public CategoryBag getCategoryBag() {
        return categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Service))
            return false;
        Service castOther = (Service) other;
        return new EqualsBuilder().append(uddiKey, castOther.uddiKey).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(uddiKey).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append(
                "intendedImplementationStyle", this.intendedImplementationStyle).append(
                "descriptions", this.descriptions).append("visibility", this.visibility).append(
                "interfaceStyle", this.interfaceStyle).append("isBusinessService",
                this.isBusinessService).append("responsabilities", this.responsabilities).append(
                "criticalSuccessFactors", this.criticalSuccessFactors).append("proposedOps",
                this.proposedOps).append("alias", this.alias).append("targetCustomers",
                this.targetCustomers).append("categoryBag", this.categoryBag).append(
                "infoProcessingStyle", this.infoProcessingStyle).append("names", this.names)
                .append("uddiKey", this.uddiKey).append("stabilityExpectations",
                        this.stabilityExpectations).append("technicalServices",
                        this.technicalServices).append("nonFunctionalRqmts",
                        this.nonFunctionalRqmts).toString();
    }

}
