/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * MessageSpecification.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.specification;

import javax.persistence.Entity;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.common.NonSearchableBaseObject;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.specification.MessageSpecification")
public class MessageSpecification extends NonSearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 2668355353100988101L;

    public enum MessageRole {
        FAULT, IN_OUT, INPUT, OUTPUT
    }

    private MessageRole role;

    private String structure;

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof MessageSpecification)) {
            return false;
        }
        final MessageSpecification castOther = (MessageSpecification) other;
        return new EqualsBuilder().append(this.role, castOther.role).append(this.structure,
                castOther.structure).isEquals();
    }

    public MessageRole getRole() {
        return this.role;
    }

    public String getStructure() {
        return this.structure;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.role).append(this.structure).toHashCode();
    }

    public void setRole(final MessageRole role) {
        this.role = role;
    }

    public void setStructure(final String structure) {
        this.structure = structure;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("role", this.role)
                .append("structure", this.structure).toString();
    }

}
