/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceSpecification.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.specification.ServiceSpecification")
@Inheritance(strategy = InheritanceType.JOINED)
public class ServiceSpecification extends VersionedSpecification {

    /**
     * 
     */
    private static final long serialVersionUID = -720509434728670906L;
    
    private String wsdlSha1;

    private Set<Binding> bindings;

    private Set<ServiceInterface> serviceInterfaces;

    private Set<TechnicalService> technicalServices;

    public ServiceSpecification() {
        this.serviceInterfaces = new HashSet<ServiceInterface>();
        this.technicalServices = new HashSet<TechnicalService>();
        this.bindings = new HashSet<Binding>();
    }

    public void addBinding(final Binding binding) {
        this.getBindings().add(binding);
        binding.getServiceSpecifications().add(this);
    }

    public void addServiceInterface(final ServiceInterface serviceInterface) {
        this.getServiceInterfaces().add(serviceInterface);
        serviceInterface.getServiceSpecs().add(this);
    }

    public void addTechnicalService(final TechnicalService technicalService) {
        this.getTechnicalServices().add(technicalService);
        technicalService.getServiceSpecifications().add(this);
    }

    @ManyToMany
    public Set<Binding> getBindings() {
        return this.bindings;
    }

    @ManyToMany
    public Set<ServiceInterface> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    @ManyToMany
    public Set<TechnicalService> getTechnicalServices() {
        return this.technicalServices;
    }

    public void setBindings(final Set<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setServiceInterfaces(final Set<ServiceInterface> serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void setTechnicalServices(final Set<TechnicalService> technicalServices) {
        this.technicalServices = technicalServices;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("bindings", this.bindings).append("serviceInterfaces",
                this.serviceInterfaces).append("technicalServices", this.technicalServices)
                .toString();
    }

    public String getWsdlSha1() {
        return wsdlSha1;
    }

    public void setWsdlSha1(String wsdlSha1) {
        this.wsdlSha1 = wsdlSha1;
    }
}
