/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SpecifiedOperation.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.service.ProposedOperation;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.specification.SpecifiedOperation")
@Searchable(root = false)
public class SpecifiedOperation extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 319403999125489629L;

    public enum OpStyleType {
        DOCUMENT, PARAMETERS, UNKNOWN
    }

    public enum OpTmType {
        NOTIFICATION, ONEWAY, REQUEST_RESPONSE, SOLICIT_RESPONSE, UNKNOWN
    }

    private Set<BindingOperation> bindingOps;

    private boolean canParticipateInTransaction;

    private boolean isAtomicTransaction;

    private boolean isNonUpdating;

    private boolean isTransactionCoordNeeded;

    private Set<MessageSpecification> messageSpecs;

    private String name;

    private String signature;

    private Set<ProposedOperation> proposedOps;

    private String purpose;

    private ServiceInterface serviceInterface;

    private String transactionCoordIsBy;

    private OpTmType transmission;

    public SpecifiedOperation() {
        this.proposedOps = new HashSet<ProposedOperation>();
        this.messageSpecs = new HashSet<MessageSpecification>();
        this.bindingOps = new HashSet<BindingOperation>();
    }

    public void addBindingOp(final BindingOperation bindingOperation) {
        this.getBindingOps().add(bindingOperation);
        bindingOperation.setSpecifiedOp(this);
    }

    public void addMessageSpec(final MessageSpecification messageSpecification) {
        this.getMessageSpecs().add(messageSpecification);
    }

    public void addProposedOp(final ProposedOperation proposedOperation) {
        this.getProposedOps().add(proposedOperation);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof SpecifiedOperation)) {
            return false;
        }
        final SpecifiedOperation castOther = (SpecifiedOperation) other;
        return new EqualsBuilder().append(this.signature, castOther.signature).isEquals();
    }

    @OneToMany(mappedBy = "specifiedOp")
    public Set<BindingOperation> getBindingOps() {
        return this.bindingOps;
    }

    @ManyToMany
    public Set<MessageSpecification> getMessageSpecs() {
        return this.messageSpecs;
    }

    @SearchableProperty
    public String getName() {
        return this.name;
    }

    @ManyToMany
    public Set<ProposedOperation> getProposedOps() {
        return this.proposedOps;
    }

    @SearchableProperty
    @Column(length = 1048576)
    public String getPurpose() {
        return this.purpose;
    }

    @ManyToOne
    @JoinColumn(name = "serviceIntId", nullable = false)
    public ServiceInterface getServiceInterface() {
        return this.serviceInterface;
    }

    public String getTransactionCoordIsBy() {
        return this.transactionCoordIsBy;
    }

    @Enumerated(EnumType.STRING)
    public OpTmType getTransmission() {
        return this.transmission;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.signature).toHashCode();
    }

    public boolean isAtomicTransaction() {
        return this.isAtomicTransaction;
    }

    public boolean isCanParticipateInTransaction() {
        return this.canParticipateInTransaction;
    }

    public boolean isNonUpdating() {
        return this.isNonUpdating;
    }

    public boolean isTransactionCoordNeeded() {
        return this.isTransactionCoordNeeded;
    }

    public void setAtomicTransaction(final boolean isAtomicTransaction) {
        this.isAtomicTransaction = isAtomicTransaction;
    }

    public void setBindingOps(final Set<BindingOperation> bindingOps) {
        this.bindingOps = bindingOps;
    }

    public void setCanParticipateInTransaction(final boolean canParticipateInTransaction) {
        this.canParticipateInTransaction = canParticipateInTransaction;
    }

    public void setMessageSpecs(final Set<MessageSpecification> messageSpecs) {
        this.messageSpecs = messageSpecs;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setNonUpdating(final boolean isNonUpdating) {
        this.isNonUpdating = isNonUpdating;
    }

    public void setProposedOps(final Set<ProposedOperation> proposedOps) {
        this.proposedOps = proposedOps;
    }

    public void setPurpose(final String purpose) {
        this.purpose = purpose;
    }

    public void setServiceInterface(final ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setTransactionCoordIsBy(final String transactionCoordIsBy) {
        this.transactionCoordIsBy = transactionCoordIsBy;
    }

    public void setTransactionCoordNeeded(final boolean isTransactionCoordNeeded) {
        this.isTransactionCoordNeeded = isTransactionCoordNeeded;
    }

    public void setTransmission(final OpTmType transmission) {
        this.transmission = transmission;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("transmission",
                this.transmission).append("canParticipateInTransaction",
                this.canParticipateInTransaction).append("bindingOps", this.bindingOps).append(
                "transactionCoordIsBy", this.transactionCoordIsBy).append("proposedOps",
                this.proposedOps).append("purpose", this.purpose).append("isNonUpdating",
                this.isNonUpdating).append("isTransactionCoordNeeded",
                this.isTransactionCoordNeeded).append("isAtomicTransaction",
                this.isAtomicTransaction).append("name", this.name).append("messageSpecs",
                this.messageSpecs).toString();
    }

    @Column(length = 1048576)
    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

}
