/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * VersionedSpecification.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.specification;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.common.TModel;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.specification.VersionedSpecification")
@Inheritance(strategy = InheritanceType.JOINED)
public class VersionedSpecification extends TModel {

    /**
     * 
     */
    private static final long serialVersionUID = -8639454814402094143L;

    private int versionNr;

    private int revisionNr;

    private int issueNr;

    public int getIssueNr() {
        return this.issueNr;
    }

    public int getRevisionNr() {
        return this.revisionNr;
    }

    public int getVersionNr() {
        return this.versionNr;
    }

    public void setIssueNr(final int issueNr) {
        this.issueNr = issueNr;
    }

    public void setRevisionNr(final int revisionNr) {
        this.revisionNr = revisionNr;
    }

    public void setVersionNr(final int versionNr) {
        this.versionNr = versionNr;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("issueNr", this.issueNr).append("revisionNr",
                this.revisionNr).append("versionNr", this.versionNr).toString();
    }

}
