/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ExecutionEnvironment.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.technology;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment")
@Inheritance(strategy = InheritanceType.JOINED)
@Searchable
public class ExecutionEnvironment extends Node {

    /**
     * 
     */
    private static final long serialVersionUID = 9167725981786067071L;

    public enum EEType {
        ESB, APPLICATION_SERVER, CLIENT, WEB_SERVER
    }

    private EEType envType;

    private String roleInFederation;

    private Processor hostProcessor;

    private EnvironmentFederation parentFederation;

    @ManyToOne
    @JoinColumn(name = "envFedId")
    @SearchableComponent
    public EnvironmentFederation getParentFederation() {
        return parentFederation;
    }

    public void setParentFederation(EnvironmentFederation parentFederation) {
        this.parentFederation = parentFederation;
    }

    @ManyToOne
    @JoinColumn(name = "hostProcessorId")
    @SearchableComponent
    public Processor getHostProcessor() {
        return hostProcessor;
    }

    public void setHostProcessor(Processor hostProcessor) {
        this.hostProcessor = hostProcessor;
    }

    @Enumerated(EnumType.STRING)
    @SearchableProperty
    public EEType getEnvType() {
        return envType;
    }

    public void setEnvType(EEType envType) {
        this.envType = envType;
    }

    @SearchableProperty
    public String getRoleInFederation() {
        return roleInFederation;
    }

    public void setRoleInFederation(String roleInFederation) {
        this.roleInFederation = roleInFederation;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append(super.toString())
                .append("roleInFederation", this.roleInFederation).append("envType", this.envType)
                .toString();
    }

}
