/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Processor.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.technology;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.technology.Processor")
@Inheritance(strategy = InheritanceType.JOINED)
@Searchable
public class Processor extends Node {

    /**
     * 
     */
    private static final long serialVersionUID = 5901811128718172427L;

    private Set<ExecutionEnvironment> executionEnvs;

    public Processor() {
        this.executionEnvs = new HashSet<ExecutionEnvironment>();
    }

    @OneToMany(mappedBy = "hostProcessor")
    public Set<ExecutionEnvironment> getExecutionEnvs() {
        return executionEnvs;
    }

    public void setExecutionEnvs(Set<ExecutionEnvironment> executionEnvs) {
        this.executionEnvs = executionEnvs;
    }

    public void addExecutionEnvironment(final ExecutionEnvironment execEnv) {
        this.getExecutionEnvs().add(execEnv);
        execEnv.setHostProcessor(this);
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append(super.toString())
                .append("executionEnvs", this.executionEnvs).toString();
    }

}
