/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UniversalCompassDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.compass.core.CompassCallback;
import org.compass.core.CompassException;
import org.compass.core.CompassHit;
import org.compass.core.CompassHits;
import org.compass.core.CompassSession;
import org.compass.spring.CompassDaoSupport;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class UniversalCompassDAOImpl extends CompassDaoSupport implements UniversalOSEMDAO {

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public List search(final String query, final Class clazz) {
        List result = new ArrayList();
        log.debug("Compass Query: " + query);
        CompassHits hits = (CompassHits) getCompassTemplate().execute(
                new CompassCallback<CompassHits>() {
                    public CompassHits doInCompass(CompassSession session) throws CompassException {
                        CompassHits result = session.queryBuilder().queryString(query).toQuery()
                                .setAliases(clazz.getSimpleName()).hits();
                        return result;
                    }
                });
        for (Iterator<CompassHit> iterator = hits.iterator(); iterator.hasNext();) {
            CompassHit hit = iterator.next();
            Object data = hit.getData();
            if (!data.getClass().getName().equals(clazz.getName())) {
                log.warn("Retrieve unexpected Object type: " + hit.getData().getClass().getName()
                        + ". Expected type was: " + clazz.getName());
            } else {
                result.add(data);
            }
        }
        return result;
    }

}
