/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UniversalCompassHibernateDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.NonUniqueResultException;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.util.CompassQueryHelper;

import com.trg.search.IMutableSearch;
import com.trg.search.SearchResult;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public class UniversalCompassHibernateDAOImpl implements UniversalUnifiedDAO {

    private UniversalORMDAO universalORMDAO;

    private UniversalOSEMDAO universalOSEMDAO;

    /**
     * {@inheritDoc}
     */
    public Object get(Class clazz, Serializable id) {
        return universalORMDAO.get(clazz, id);
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz) {
        return universalORMDAO.getAll(clazz);
    }

    /**
     * {@inheritDoc}
     */
    public void remove(Class clazz, Serializable id) {
        universalORMDAO.remove(clazz, id);

    }

    /**
     * {@inheritDoc}
     */
    public Object save(Object o) {
        return universalORMDAO.save(o);
    }

    /**
     * {@inheritDoc}
     */
    public List search(String query, Class clazz) {
        return universalOSEMDAO.search(query, clazz);
    }

    /**
     * {@inheritDoc}
     */
    public List<? extends SearchableBaseObject> searchORMResult(String query,
            Class<? extends SearchableBaseObject> clazz, RequestOptions requestOptions) {
        List<? extends SearchableBaseObject> osemResults = this.search(query, clazz);
        List<String> ids = new ArrayList<String>();
        for (SearchableBaseObject t : osemResults) {
            ids.add(t.getId());
        }
        return this.getAll(clazz, ids, requestOptions);
    }

    /**
     * {@inheritDoc}
     */
    public List<? extends SearchableBaseObject> searchORMResult(String[] criteria,
            String[] searchedProperties, Class<? extends SearchableBaseObject> clazz,
            RequestOptions requestOptions) {
        String query = CompassQueryHelper.decorateQuery(criteria, searchedProperties, clazz
                .getSimpleName());
        return this.searchORMResult(query, clazz, requestOptions);
    }

    public void setUniversalORMDAO(UniversalORMDAO universalORMDAO) {
        this.universalORMDAO = universalORMDAO;
    }

    public void setUniversalOSEMDAO(UniversalOSEMDAO universalOSEMDAO) {
        this.universalOSEMDAO = universalOSEMDAO;
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz, List ids) {
        return this.universalORMDAO.getAll(clazz, ids);
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz, List ids, RequestOptions requestOptions) {
        return this.universalORMDAO.getAll(clazz, ids, requestOptions);
    }

    /**
     * {@inheritDoc}
     */
    public List getAll(Class clazz, RequestOptions requestOptionsTO) {
        return this.universalORMDAO.getAll(clazz, requestOptionsTO);
    }

    /**
     * {@inheritDoc}
     */
    public List<? extends SearchableBaseObject> searchORMResult(String query,
            Class<? extends SearchableBaseObject> clazz) {
        return this.searchORMResult(query, clazz, null);
    }

    /**
     * {@inheritDoc}
     */
    public List<? extends SearchableBaseObject> searchORMResult(String[] criteria,
            String[] searchedProperties, Class<? extends SearchableBaseObject> clazz) {
        return this.searchORMResult(criteria, searchedProperties, clazz, null);
    }

    /**
     * {@inheritDoc}
     */
    public List searchEquals(Class clazz, String[] criteria, String[] properties,
            RequestOptions requestOptionsTO) {
        return this.universalORMDAO.searchEquals(clazz, criteria, properties, requestOptionsTO);
    }

    /**
     * {@inheritDoc}
     */
    public List searchLike(Class clazz, String[] criteria, String[] properties,
            RequestOptions requestOptionsTO) {
        return this.universalORMDAO.searchLike(clazz, criteria, properties, requestOptionsTO);
    }

    /**
     * {@inheritDoc}
     */
    public int count(Class clazz, IMutableSearch search) {
        return universalORMDAO.count(clazz, search);
    }

    /**
     * {@inheritDoc}
     */
    public List search(Class clazz, IMutableSearch search) {
        return universalORMDAO.search(clazz, search);
    }

    /**
     * {@inheritDoc}
     */
    public SearchResult searchAndCount(Class clazz, IMutableSearch search) {
        return universalORMDAO.searchAndCount(clazz, search);
    }

    /**
     * {@inheritDoc}
     */
    public Object searchUnique(Class clazz, IMutableSearch search) throws NonUniqueResultException {
        return universalORMDAO.searchUnique(clazz, search);
    }

    /**
     * {@inheritDoc}
     */
    public boolean exists(Class clazz, Serializable id) {
        return universalORMDAO.exists(clazz, id);
    }

    /**
     * {@inheritDoc}
     */
    public List findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        return universalORMDAO.findByNamedQuery(queryName, queryParams);
    }

    public Object merge(Object object) {
        return universalORMDAO.merge(object);
    }

    public Object persist(Object object) {
        return universalORMDAO.persist(object);
    }

    public Object saveOnly(Object object) {
        return universalORMDAO.saveOnly(object);
    }

    public Object updateOnly(Object object) {
        return universalORMDAO.updateOnly(object);
    }

    /**
     * {@inheritDoc}
     */
    public void removeAll(Class clazz, List ids) {
        universalORMDAO.removeAll(clazz, ids);
    }

    public void removeAll(List objects) {
        universalORMDAO.removeAll(objects);
    }

}
