/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationUnitDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao.organization.hibernate;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericHibernateDAOImpl;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.service.TransfertObjectAssemblerImpl;

import com.trg.search.Filter;
import com.trg.search.Search;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class OrganizationUnitDAOImpl extends GenericHibernateDAOImpl<OrganizationUnit, String>
        implements OrganizationUnitDAO {

    public OrganizationUnit getOrgUnitByNameAndCity(String name, String city) {
        Search search = new Search();
        search.addFilterAnd(Filter.some("names", Filter.equal("name", name)),
                Filter.some("addresses", Filter.some("addressLines", Filter.and(Filter.equal(
                        "keyName", TransfertObjectAssemblerImpl.CITY_KEY), Filter.equal(
                        "addressLine", city)))));
        return searchUnique(search);
    }

    public List<OrganizationUnit> getOrgAndChildren(String initialOrgId) {
        List<OrganizationUnit> result = new ArrayList<OrganizationUnit>();

        OrganizationUnit initialOrg = this.get(initialOrgId);
        addChildOrg(result, initialOrg);

        return result;
    }

    public List<OrganizationUnit> getAllWithoutMeAndMyChildren(String initialOrgId)
            throws DAOLayerException {
        List<OrganizationUnit> result = new ArrayList<OrganizationUnit>();
        OrganizationUnit initialOrg = this.get(initialOrgId);
        if (initialOrg == null) {
            throw new DAOLayerException("No initial organization found for the given id: "
                    + initialOrgId);
        }
        addChildOrg(result, initialOrg);

        // Create id list
        List<String> idsToExclude = new ArrayList<String>();
        for (OrganizationUnit org : result) {
            idsToExclude.add(org.getId());
        }

        // Retrieve all orgs excluding the previous ones
        Search search = new Search();
        search.addFilterNotIn("id", idsToExclude);
        search.addFetch("names");
        search.addSortAsc("names.name");

        return search(search);
    }

    private void addChildOrg(List<OrganizationUnit> result, OrganizationUnit initialOrg) {
        // Add me
        result.add(initialOrg);

        // Add children recursively
        if (initialOrg != null) {
            Set<Party> parties = initialOrg.getParties();
            if (parties != null && !parties.isEmpty()) {
                for (Party party : parties) {
                    if (party instanceof OrganizationUnit) {
                        addChildOrg(result, (OrganizationUnit) party);
                    }
                }
            }
        }
    }

}
