/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TModelManagerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.common;

import java.util.ArrayList;
import java.util.List;

import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.common.TModelManager;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.CategoryValueDAO;
import org.ow2.dragon.persistence.dao.common.IdentifierDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

/**
 * @author ofabre
 * 
 */
public class TModelManagerImpl implements TModelManager {

    private CategoryDAO categoryDAO;

    private IdentifierDAO identifierDAO;

    private CategoryValueDAO categoryValueDAO;

    private TransfertObjectAssembler transfertObjectAssembler;

    @CheckAllArgumentsNotNull
    public List<CategoryValueTO> loadCategoryValues(String categoryId) {
        return transfertObjectAssembler.toCategoryValuesTO(categoryValueDAO
                .loadCategoryValues(categoryId));
    }

    public List<CategoryTO> loadServiceCategories() {
        List<CategoryTO> result = new ArrayList<CategoryTO>();

        List<Category> categoryBOs = categoryDAO.loadServiceRelatedCategories();

        if (categoryBOs != null) {
            for (Category category : categoryBOs) {
                result.add(transfertObjectAssembler.toCategoryTO(category));
            }
        }

        return result;
    }

    public List<CategoryTO> loadOrganizationCategories() {
        List<CategoryTO> result = new ArrayList<CategoryTO>();

        List<Category> categoryBOs = categoryDAO.loadOrganizationRelatedCategories();

        if (categoryBOs != null) {
            for (Category category : categoryBOs) {
                result.add(transfertObjectAssembler.toCategoryTO(category));
            }
        }

        return result;
    }

    public List<IdentifierTO> loadOrganizationIdentifierSystems() {
        List<IdentifierTO> result = new ArrayList<IdentifierTO>();

        List<Identifier> identifierBOs = identifierDAO.loadOrganizationRelatedIdentifierSystems();

        if (identifierBOs != null) {
            for (Identifier identifier : identifierBOs) {
                result.add(transfertObjectAssembler.toIdentifierTO(identifier));
            }
        }

        return result;
    }

    public List<CategoryTO> loadEndpointCategories() {
        List<CategoryTO> result = new ArrayList<CategoryTO>();

        List<Category> categoryBOs = categoryDAO.loadEndpointRelatedCategories();

        if (categoryBOs != null) {
            for (Category category : categoryBOs) {
                result.add(transfertObjectAssembler.toCategoryTO(category));
            }
        }

        return result;
    }

    public void setCategoryDAO(CategoryDAO categoryDAO) {
        this.categoryDAO = categoryDAO;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    public void setCategoryValueDAO(CategoryValueDAO categoryValueDAO) {
        this.categoryValueDAO = categoryValueDAO;
    }

    public void setIdentifierDAO(IdentifierDAO identifierDAO) {
        this.identifierDAO = identifierDAO;
    }

}
