/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TransfertObjectAssemblerImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.sla;

import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.ow2.dragon.persistence.dao.organization.PartyDAO;

import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle.State;



/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class SLATransfertObjectAssemblerImpl implements SLATransfertObjectAssembler {



    private PartyDAO partyDAO;

    public Party getPartyBO(final String id) {
        Party party = null;
        if (id != null) {
            party = this.partyDAO.get(id);
        }
        return party;
    }

    /**
     * @return the partyDAO
     */
    public PartyDAO getPartyDAO() {
        return this.partyDAO;
    }
    
    /**
     * @param partyDAO
     *            the partyDAO to set
     */
    public void setPartyDAO(final PartyDAO partyDAO) {
        this.partyDAO = partyDAO;
    }

 
    public ManagedAgreement toManagedAgreementBO(final ManagedAgreementTO maTO)
            throws WSAgreementException {
        final ManagedAgreement maBO = new ManagedAgreement();
        maBO.setClient(this.getPartyBO(maTO.getIdClient()));
        maBO.setProvider(this.getPartyBO(maTO.getIdProvider()));
        maBO.setName(maTO.getAgreement().getName());
        if(maTO.getAgreement() instanceof AgreementLifeCycle) {
        	maBO.setState(((AgreementLifeCycle)maTO.getAgreement()).getState().value());
        } else {
        	maBO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        }
        return maBO;
    }

    public void toManagedAgreementBO(final ManagedAgreementTO maTO, final ManagedAgreement maBO)
            throws WSAgreementException {
        maBO.setClient(this.getPartyBO(maTO.getIdClient()));
        maBO.setProvider(this.getPartyBO(maTO.getIdProvider()));
        maBO.setName(maTO.getAgreement().getName());
        if(maTO.getAgreement() instanceof AgreementLifeCycle) {
        	maBO.setState(((AgreementLifeCycle)maTO.getAgreement()).getState().value());
        } else {
        	maBO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        }
    }

    public ManagedAgreementTO toManagedAgreementTO(final ManagedAgreement maBO)
            throws WSAgreementException {
        final ManagedAgreementTO maTO = new ManagedAgreementTO();
        maTO.setId(maBO.getId());
        if (maBO.getClient() != null) {
            maTO.setIdClient(maBO.getClient().getId());
        }
        
        if (maBO.getProvider() != null) {
            maTO.setIdProvider(maBO.getProvider().getId());
        }
        if(maBO.getState() == null) {
        	maTO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        } else {
        	maTO.setState(maBO.getState());
        }
        return maTO;
    }

}
