/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TechnologyTransferObjectAssembler.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.technology;

import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.persistence.bo.technology.EnvironmentFederation;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager;
import org.ow2.dragon.persistence.bo.technology.Processor;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
public interface TechnologyTransferObjectAssembler {

    ExecutionEnvironmentTO toExecutionEnvironmentTO(
            final ExecutionEnvironment executionEnvironmentBO);

    ExecutionEnvironmentManagerTO toExecutionEnvironmentManagerTO(
            final ExecutionEnvironmentManager executionEnvironmentManagerBO);

    ProcessorTO toProcessorTO(final Processor processorBO);
    
    EnvironmentFederationTO toEnvironmentFederationTO(
            final EnvironmentFederation environmentFederationBO);

}
