/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.api.to.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.BindingTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.ProtocolTO;
import org.ow2.dragon.api.to.deployment.RatingTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.deployment.TransportTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointTO {
    private TechnicalServiceTO techService;
    private BindingTO binding;
    private String id;
    private String name;
    private String networkAddress;
    private Set<ProtocolTO> protocols;
    private Set<TransportTO> transports;
    private String wsdlFile;
    private String hostProcessorId;
    private String hostExecEnvId;
    private List<KeyedRefTO> categories;
    private RatingTO ratingTO;
    private float globalRating;
    private List<CommentTO> comments;
    private Set<String> tags;

    public RatingTO getRatingTO() {
        if (this.ratingTO == null) {
            this.ratingTO = new RatingTO();
        }
        return this.ratingTO;
    }

    public float getGlobalRating() {
        return this.globalRating;
    }

    public void setRatingTO(RatingTO ratingTO) {
        this.ratingTO = ratingTO;
    }

    public void setGlobalRating(float globalRating) {
        this.globalRating = globalRating;
    }

    public Set<String> getTags() {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public List<CommentTO> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<CommentTO>();
        }
        return this.comments;
    }

    public void setComments(List<CommentTO> comments) {
        this.comments = comments;
    }

    public BindingTO getBinding() {
        return this.binding;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public TechnicalServiceTO getTechService() {
        return this.techService;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setBinding(BindingTO binding) {
        this.binding = binding;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public void setTechService(TechnicalServiceTO service) {
        this.techService = service;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getHostProcessorId() {
        return this.hostProcessorId;
    }

    public void setHostProcessorId(String hostProcessorId) {
        this.hostProcessorId = hostProcessorId;
    }

    public String getHostExecEnvId() {
        return this.hostExecEnvId;
    }

    public void setHostExecEnvId(String hostExecEnvId) {
        this.hostExecEnvId = hostExecEnvId;
    }

    public List<KeyedRefTO> getCategories() {
        return this.categories;
    }

    public void setCategories(List<KeyedRefTO> categories) {
        this.categories = categories;
    }

    public String getProtocol() {
        StringBuffer result = new StringBuffer("");
        if (this.protocols != null) {
            for (ProtocolTO protocolTO : this.protocols) {
                if (protocolTO.getId().equals("uddi:uddi.org:protocol:soap")) {
                    result.append("SOAP1.1 over ");
                    continue;
                }
                if (protocolTO.getId().equals("uddi:dragon.org:protocol:soap12")) {
                    result.append("SOAP1.2 over ");
                    continue;
                }
                if (!protocolTO.getId().equals("uddi:uddi.org:protocol:http")) continue;
                result.append("HTTP over ");
            }
            for (TransportTO transportTO : this.transports) {
                if (transportTO.getId().equals("uddi:uddi.org:transport:ftp")) {
                    result.append("FTP");
                    continue;
                }
                if (transportTO.getId().equals("uddi:uddi.org:transport:http")) {
                    result.append("HTTP");
                    continue;
                }
                if (!transportTO.getId().equals("uddi:uddi.org:transport:smtp")) continue;
                result.append("SMTP");
            }
        }
        return result.toString();
    }

    public Set<ProtocolTO> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Set<ProtocolTO> protocols) {
        this.protocols = protocols;
    }

    public Set<TransportTO> getTransports() {
        return this.transports;
    }

    public void setTransports(Set<TransportTO> transports) {
        this.transports = transports;
    }
}

