/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.common;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.common.TModel")
@Inheritance(strategy=InheritanceType.JOINED)
@Searchable(root=false)
public class TModel
extends SearchableBaseObject {
    private static final long serialVersionUID = -6401150800678521372L;
    private Timestamp version;
    @SearchableComponent
    private Name name;
    private boolean deleted;
    @SearchableComponent
    private List<Description> descriptions;
    private List<SimpleFile> overviewDocs;
    private List<KeyedReference> identifierBag;
    private CategoryBag categoryBag;

    public TModel(Name name, boolean deleted, List<Description> descriptions, List<SimpleFile> overviewDocs, List<KeyedReference> identifierBag, CategoryBag categoryBag) {
        this.name = name;
        this.deleted = deleted;
        this.descriptions = descriptions != null ? descriptions : new ArrayList<Description>();
        this.overviewDocs = overviewDocs != null ? overviewDocs : new ArrayList<SimpleFile>();
        this.identifierBag = identifierBag != null ? identifierBag : new ArrayList<KeyedReference>();
        this.categoryBag = categoryBag;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TModel)) {
            return false;
        }
        TModel castOther = (TModel)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).append(this.descriptions, castOther.descriptions).append(this.identifierBag, castOther.identifierBag).append((Object)this.categoryBag, (Object)castOther.categoryBag).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.descriptions).append(this.identifierBag).append((Object)this.categoryBag).toHashCode();
    }

    public TModel() {
        this.descriptions = new ArrayList<Description>();
        this.overviewDocs = new ArrayList<SimpleFile>();
        this.identifierBag = new ArrayList<KeyedReference>();
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addOverviewDoc(SimpleFile overviewDoc) {
        this.getOverviewDocs().add(overviewDoc);
    }

    public void addIdentifier(KeyedReference identifier) {
        this.getIdentifierBag().add(identifier);
    }

    @OneToOne(cascade={CascadeType.ALL})
    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<SimpleFile> getOverviewDocs() {
        return this.overviewDocs;
    }

    public void setOverviewDocs(List<SimpleFile> overviewDocs) {
        this.overviewDocs = overviewDocs;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<KeyedReference> getIdentifierBag() {
        return this.identifierBag;
    }

    public void setIdentifierBag(List<KeyedReference> identifierBag) {
        this.identifierBag = identifierBag;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("deleted", this.deleted).append("descriptions", this.descriptions).append("categoryBag", (Object)this.categoryBag).append("identifierBag", this.identifierBag).append("overviewDocs", this.overviewDocs).append("name", (Object)this.name).toString();
    }

    @Version
    public Timestamp getVersion() {
        return this.version;
    }

    public void setVersion(Timestamp version) {
        this.version = version;
    }
}

